package com.example.Vezba.model;

import javax.persistence.*;
import java.util.List;

@Entity
@Table(name="podkategorije")
public class Podkategorija {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name="id_podkategorije")
    private Integer idPodkategorije;

    @Column(nullable = false, unique = false, length = 255)
    private String naziv;

    @Column(nullable = false, unique = false, length = 255,name="id_kategorije")
    private Integer idKategorije;

    @ManyToMany(mappedBy = "podkategorije")
    private List<Oglas> oglasi;

    public Podkategorija(){

    }

    public Podkategorija(String naziv,Integer id_kategorije) {
        this.naziv = naziv;
        this.idKategorije=id_kategorije;
    }

    public Podkategorija(Integer id_podkategorije, String naziv,Integer id_kategorije) {
        this.idPodkategorije = id_podkategorije;
        this.naziv = naziv;
        this.idKategorije=id_podkategorije;
    }

    public Integer getIdPodkategorije() {
        return idPodkategorije ;
    }

    public void setIdPodkategorije(Integer id_podkategorije) {
        this.idPodkategorije  = id_podkategorije;
    }

    public String getNaziv() {
        return naziv;
    }

    public void setNaziv(String naziv) {
        this.naziv = naziv;
    }

    public Integer getIdKategorije() {
        return idKategorije;
    }

    public void setIdKategorije(Integer id_kategorije) {
        this.idKategorije = id_kategorije;
    }
}
