package com.example.Vezba.repository;

import com.example.Vezba.model.Korisnik;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

public interface KorisnikRepository extends JpaRepository<Korisnik, Integer>{

    @Query("SELECT k FROM Korisnik k WHERE k.email = ?1")
    Korisnik findByEmail(String email);

    @Query("SELECT k FROM Korisnik k WHERE k.idKorisnika = ?1")
    Korisnik findById(int id);

    @Query("SELECT k.slika FROM Korisnik k WHERE k.idKorisnika = ?1")
    byte[] findSlikaByIdKorisnika(int id);


    List<Korisnik> findByImeLike(String s);

    List<Korisnik> findByPrezimeLike(String s);

    List<Korisnik> findByIdTipaKorisnika(Integer k);

    @Transactional
    @Modifying
    @Query("UPDATE Korisnik k SET k.idTipaKorisnika=1 WHERE  k.idKorisnika=?1")
    int upadateTipById(Integer idKorisnika);
}