package com.example.Vezba.repository;

import com.example.Vezba.model.Prijava;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

public interface PrijavaRepository extends JpaRepository<Prijava, Integer> {

    @Query("SELECT p.idOglasa FROM Prijava p WHERE p.idKorisnika=?1")
    List<Integer> findIdOglasaByIdKorisnika(Integer korisnikId);

    @Query("SELECT p.idKorisnika FROM Prijava p WHERE p.idOglasa=?1")
    Iterable<Integer> findIdKorisnikaByIdOglasa(Integer idOglasa);

    @Query("SELECT p FROM Prijava p WHERE p.idOglasa=?1 and p.idKorisnika=?2")
    List<Prijava> findByIdOglasaByIdKorisnika(Integer idOglasa,Integer idKorisnika);

}
