package com.example.Vezba.service;

import com.example.Vezba.security.CustomUserDetails;
import com.example.Vezba.model.Korisnik;
import com.example.Vezba.repository.KorisnikRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class CustomUserDetailsService implements UserDetailsService {

    @Autowired
    private KorisnikRepository repository;

    @Override
    public UserDetails loadUserByUsername(String email) throws UsernameNotFoundException {
        Korisnik korisnik = repository.findByEmail(email);
        if(korisnik == null)
            throw new UsernameNotFoundException("Ne postoji korisnik sa ovim emailom");

        return new CustomUserDetails(korisnik);
    }

}