package com.example.Vezba;

import static org.assertj.core.api.Assertions.assertThat;

import com.example.Vezba.model.Korisnik;
import com.example.Vezba.repository.KorisnikRepository;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.jdbc.AutoConfigureTestDatabase;
import org.springframework.boot.test.autoconfigure.jdbc.AutoConfigureTestDatabase.Replace;
import org.springframework.boot.test.autoconfigure.orm.jpa.DataJpaTest;
import org.springframework.boot.test.autoconfigure.orm.jpa.TestEntityManager;
import org.springframework.test.annotation.Rollback;

@DataJpaTest
@AutoConfigureTestDatabase(replace = Replace.NONE)
@Rollback(false)
public class KorisnikRepositoryTests {

    @Autowired
    private KorisnikRepository repository;

    @Autowired
    private TestEntityManager entityManager;

    /*
    @Test
    public void testKreirajKorisnika(){
        Korisnik k = new Korisnik("fkocovic@gmail.com","koca","Filip","sifra123","0693452522","Kocovic",1,10F);

        Korisnik sacuvaniKorisnik = repository.save(k);
        Korisnik postojeciKorisnik = entityManager.find(Korisnik.class,sacuvaniKorisnik.getId_korisnika());

        assertThat(postojeciKorisnik.getEmail()).isEqualTo(k.getEmail());

    }

     */

    @Test
    public void testFindUserByEmail(){
        String email = "fkocovci@gmail.com";

        Korisnik k = repository.findByEmail(email);

        assertThat(k).isNotNull();
    }


}
