package com.example.Vezba.controller;

import com.example.Vezba.model.*;
import com.example.Vezba.repository.KorisnikRepository;
import com.example.Vezba.repository.OglasRepository;
import com.example.Vezba.repository.PrijavaRepository;
import com.example.Vezba.security.CustomUserDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;

import static java.lang.Integer.parseInt;

@Controller
public class PrijavljeniController {
    @Autowired
    KorisnikRepository korisnikRepository;

    @Autowired
    PrijavaRepository prijavaRepository;

    @Autowired
    OglasRepository oglasRepository;

    @GetMapping("/prijavljeni")
    public String izlistajRadnike(Model model,
                                     @RequestParam MultiValueMap<String,String> parametri){
        LinkedMultiValueMap mapaParamatara=new LinkedMultiValueMap(parametri);

        Integer idOglasa=parseInt((String)(mapaParamatara.get("id").get(0)));

        //kontrola pristupa
        //samo vlasnik oglasa ima pristup

        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        CustomUserDetails userDetails = (CustomUserDetails) authentication.getPrincipal();
        if(userDetails.getKorisnikId()!=oglasRepository.findById(idOglasa).get().getIdOglasavaca()){
            return "error";
        }

        //------------------



        HashSet<Korisnik> skupRadnika = new HashSet(korisnikRepository.findAllById(prijavaRepository.findIdKorisnikaByIdOglasa(idOglasa)));

        List<Korisnik> listaKorisnika = new ArrayList<>();


        List<String> pretraga=mapaParamatara.get("pretraga");
        List<String> tip_sortiranja=mapaParamatara.get("sortBy");

        if(pretraga!=null ) {
            if(pretraga!=null && !pretraga.get(0).equals("")) {
                for(Korisnik k:korisnikRepository.findByPrezimeLike("%"+pretraga.get(0)+"%"))
                    listaKorisnika.add(k);
                for(Korisnik k:korisnikRepository.findByImeLike("%"+pretraga.get(0)+"%"))
                    listaKorisnika.add(k);

                skupRadnika.retainAll(listaKorisnika);
            }
        }

        List<Korisnik> listaRadnika = new ArrayList<>(skupRadnika);

        if(tip_sortiranja!=null) {
            String sort = tip_sortiranja.get(0);
            switch(sort){
                case "stari":
                    listaRadnika.sort(new AscendingSortById());
                    break;
                default:
                    listaRadnika.sort(new DesceningSortById());
                    break;
            }
        }

        model.addAttribute("oglas",oglasRepository.getById(idOglasa));
        model.addAttribute("radnici", listaRadnika);

        return "prijavljeni";
    }
    @GetMapping("/cv")
    public void preuzmiCv(@RequestParam("id") Integer id, HttpServletResponse resp) throws IOException {
        Korisnik k=korisnikRepository.getById(id);
        byte[] bitovi=k.getCv();

        resp.setContentType(MimeTypeUtils.APPLICATION_OCTET_STREAM.getType());
        resp.setHeader("Content-disposition","attachment; filename ="+"cv_korisnika_"+id+".pdf");
        resp.setContentLength(bitovi.length);

        OutputStream os=resp.getOutputStream();
        os.write(bitovi,0,bitovi.length);
        os.close();
    }
}
