package com.example.Vezba.model;

import ch.qos.logback.core.rolling.helper.FileStoreUtil;
import org.apache.commons.io.FileUtils;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.*;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;

@Entity
@Table(name = "korisnici")
public class Korisnik {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name="id_korisnika")
    private Integer idKorisnika;

    @Column(nullable = false, unique = true, length = 45)
    private String email;

    @Column(nullable = false, unique = true, length = 45)
    private String username;

    @Column(nullable = false, length = 45)
    private String ime;

    @Column(nullable = false, length = 64)
    private String lozinka;

    @Column(nullable = false, length = 45)
    private String telefon;

    @Column(nullable = false, length = 45)
    private String prezime;

    @Column(name="id_tipa_korisnika",nullable = false)
    private Integer idTipaKorisnika;

    @Column(nullable = true)
    private Float ocena=0f;


    @Column(nullable = true)
    @Lob
    @Basic(fetch = FetchType.LAZY)
    private byte[] slika=null;


    @Column(nullable = true)
    @Lob
    @Basic(fetch = FetchType.LAZY)
    private byte[] cv=null;

    //FOREIGN KEYS
    @OneToMany(
            cascade = CascadeType.ALL,
            orphanRemoval = true
    )
    @JoinColumn(name="id_oglasavaca")
    private List<Oglas> postavljeniOglasi=new ArrayList<>();

    @OneToMany(
            cascade = CascadeType.ALL,
            orphanRemoval = true
    )
    @JoinColumn(name="id_korisnika")
    private List<Prijava> poslatePrijave;

    @OneToMany(
            cascade = CascadeType.ALL,
            orphanRemoval = true
    )
    @JoinColumn(name="id_poslodavca")
    private List<Ocena> ocene=new ArrayList<>();

    @OneToMany(
            cascade = CascadeType.ALL,
            orphanRemoval = true
    )
    @JoinColumn(name="id_ocenjivaca")
    private List<Ocena> dateOcene=new ArrayList<>();

    @OneToMany(
            cascade = CascadeType.ALL,
            orphanRemoval = true
    )
    @JoinColumn(name="id_korisnika")
    private List<Lajk> lajkovi=new ArrayList<>();

    @OneToMany(
            cascade = CascadeType.ALL,
            orphanRemoval = true,
            mappedBy = "korisnik"
    )
    private List<Komentar> komentari=new ArrayList<>();


//CONSTRUCTORS
    //CONSTRUCTORS
    //CONSTRUCTORS

    //DEFAULTNI
    public Korisnik() {
    }


    //SVE INFO
    public Korisnik(Integer id_korisnika,
                    String email,
                    String username,
                    String ime,
                    String lozinka,
                    String telefon,
                    String prezime,
                    Date datum_rodjenja,
                    Integer id_tipa_korisnika,
                    Float ocena,
                    byte[] slika,
                    byte[] cv) {
        this.idKorisnika = id_korisnika;
        this.email = email;
        this.username = username;
        this.ime = ime;
        this.lozinka = lozinka;
        this.telefon = telefon;
        this.prezime = prezime;
        this.idTipaKorisnika = id_tipa_korisnika;
        this.ocena = ocena;

        this.slika=slika;
        this.cv=cv;
    }

    //SVE SEM ID_KORISNIKA
    public Korisnik(String email,
                    String username,
                    String ime,
                    String lozinka,
                    String telefon,
                    String prezime,
                    Integer id_tipa_korisnika,
                    Float ocena,
                    byte[] slika,
                    byte[] cv) {
        this.email = email;
        this.username = username;
        this.ime = ime;
        this.lozinka = lozinka;
        this.telefon = telefon;
        this.prezime = prezime;
        this.idTipaKorisnika = id_tipa_korisnika;
        this.ocena = ocena;

        this.slika = slika;
        this.cv = cv;
    }

    //GETTERS AND SETTERS
    //GETTERS AND SETTERS
    //GETTERS AND SETTERS

    public Integer getIdKorisnika() {
        return idKorisnika;
    }

    public void setIdKorisnika(Integer id_korisnika) {
        this.idKorisnika = id_korisnika;
    }

    public String getIme() {
        return ime;
    }

    public void setIme(String ime) {
        this.ime = ime;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getLozinka() {
        return lozinka;
    }

    public void setLozinka(String lozinka) {
        this.lozinka = lozinka;
    }


    public String getTelefon() {
        return telefon;
    }

    public void setTelefon(String telefon) {
        this.telefon = telefon;
    }

    public Integer getIdTipaKorisnika() {
        return idTipaKorisnika;
    }

    public void setIdTipaKorisnika(Integer id_tipa_korisnika) {
        this.idTipaKorisnika = id_tipa_korisnika;
    }

    public String getRole(){
        switch(idTipaKorisnika){
            case 1:
                    return "ROLE_ADMIN";
            case 2:
                    return "ROLE_POSLODAVAC";
            case 3:
                    return "ROLE_NEZAPOSLENI";
            case 4:
                return "ROLE_NEODOBREN";
            default:
                return "ROLE_ANON";
        }
    }

    public String getPrezime() {
        return prezime;
    }

    public void setPrezime(String prezime) {
        this.prezime = prezime;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getOcena() {
        if(ocene.size()==0)
            return "Neocenjen ";
        Integer ocena=0;
        for(Ocena o:ocene){
            ocena+=o.getOcena();
        }
        return Float.toString(ocena/(float)ocene.size());
    }

    public void setOcena(Float ocena) {
        this.ocena = ocena;
    }

    public byte[] getSlika() throws IOException {
        if(slika!=null)
            return slika;
        else{
            byte[] s= Files.readAllBytes(Path.of("src/main/java/com/example/Vezba/model/default-user.jpeg"));
            return s;
        }
    }

    public String getEncodedPic(){
        String slika=null;
        try {
            slika= Base64.getEncoder().encodeToString(getSlika());
        } catch (IOException e) {
            e.printStackTrace();
        }
        return slika;

    }

    public void setSlika(byte[] slika) {
        this.slika = slika;
    }

    public byte[] getCv() {
        return cv;
    }

    public Boolean imaCv(){
        if(cv!=null)
            return true;
        return false;
    }

    public void setCv(byte[] cv) {
        this.cv = cv;
    }

    public List<Oglas> getPostavljeniOglasi() {
        return postavljeniOglasi;
    }

    public void setPostavljeniOglasi(List<Oglas> postavljeniOglasi) {
        this.postavljeniOglasi = postavljeniOglasi;
    }

    public List<Prijava> getPoslatePrijave() {
        return poslatePrijave;
    }

    public void setPoslatePrijave(List<Prijava> poslatePrijave) {
        this.poslatePrijave = poslatePrijave;
    }

    public List<Ocena> getOcene() {
        return ocene;
    }

    public void setOcene(List<Ocena> ocene) {
        this.ocene = ocene;
    }

    public List<Ocena> getDateOcene() {
        return dateOcene;
    }

    public void setDateOcene(List<Ocena> dateOcene) {
        this.dateOcene = dateOcene;
    }

    public List<Lajk> getLajkovi() {
        return lajkovi;
    }

    public void setLajkovi(List<Lajk> lajkovi) {
        this.lajkovi = lajkovi;
    }

    public Boolean getImaCv() {
        if(cv!=null)
            return true;
        return false;
    }

}