package com.example.Vezba.model;

import javax.persistence.*;
import java.util.List;

@Entity
@Table(name = "lokacije")
public class Lokacija {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name="id_lokacije")
    private Integer idLokacije;

    @Column(nullable = false, unique = true, length = 45)
    private String naziv;

    @OneToMany(
            cascade = CascadeType.ALL,
            orphanRemoval = true
    )
    @JoinColumn(name="id_lokacije")
    private List<Oglas> oglasi;

    public Lokacija(){

    }

    public Lokacija(String naziv) {
        this.naziv = naziv;
    }

    public Lokacija(Integer id_lokacije, String naziv) {
        this.idLokacije = id_lokacije;
        this.naziv = naziv;
    }

    public Integer getIdLokacije() {
        return idLokacije;
    }

    public String getNaziv() {
        return naziv;
    }

    public void setIdLokacije(Integer id_lokacije) {
        this.idLokacije = id_lokacije;
    }

    public void setNaziv(String naziv) {
        this.naziv = naziv;
    }
}
