package com.example.Vezba.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;

import javax.persistence.*;
import java.util.ArrayList;
import java.util.List;

@Entity
@Table(name = "oglasi")
public class Oglas {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name="id_oglasa")
    private Integer idOglasa;

    @Column(nullable = false, unique = false, length = 255)
    private String opis;

    @Column(nullable = false, unique = false, length = 45)
    private String naslov;

    @Column(name="id_oglasavaca")
    private Integer idOglasavaca;

    @Column(nullable = false, unique = false,name="id_kategorije")
    private Integer idKategorije;

    @Column(nullable = false, unique = false,name="id_lokacije")
    private Integer idLokacije;

    @Column(nullable = false, unique = false,name="broj_lajkova")
    private Integer brojLajkova=0;

    @Column(nullable = false, unique = false,name="broj_pregleda")
    private Integer brojPregleda=0;

    @Column(nullable = false, unique = false,name="rad_od_kuce")
    private Boolean radOdKuce;

    @Column(nullable = false, unique = false,name="broj_prijava")
    private Integer brojPrijava=0;

    @Column(nullable = true, unique = false,name="plata")
    private Integer plata;

    @OneToMany(
            cascade = CascadeType.ALL,
            orphanRemoval = true
    )
    @JoinColumn(name="id_oglasa")
    private List<Prijava> prijave=new ArrayList<>();

    @OneToMany(
            cascade = CascadeType.ALL,
            orphanRemoval = true
    )
    @JoinColumn(name="id_oglasa")
    private List<Lajk> lajkovi=new ArrayList<>();

    @OneToMany(
            cascade = CascadeType.ALL,
            orphanRemoval = true
    )
    @JoinColumn(name="id_oglasa")
    private List<Komentar> komentari=new ArrayList<>();

    @ManyToMany
    @JoinTable(
            name = "podkategorije_oglasa",
            joinColumns = @JoinColumn(name = "id_oglasa"),
            inverseJoinColumns = @JoinColumn(name = "id_podkategorije"))
    private List<Podkategorija> podkategorije=new ArrayList<>();

    @Column(nullable = false, unique = false)
    private String pozicija;


    public Oglas() {
    }

    public Oglas(String opis,
                 String naslov,
                 Integer id_oglasavaca,
                 Integer id_kategorije,
                 Integer id_lokacije,
                 Boolean radOdKuce,
                 String pozicija,
                 Integer plata) {
        this.opis = opis;
        this.naslov = naslov;
        this.idOglasavaca = id_oglasavaca;
        this.idKategorije = id_kategorije;
        this.idLokacije = id_lokacije;
        this.radOdKuce = radOdKuce;
        this.pozicija = pozicija;
        this.plata=plata;
    }

    public Oglas(Integer id_oglasa,
                 String opis, String naslov,
                 Integer id_oglasavaca,
                 Integer id_kategorije,
                 Integer id_lokacije,
                 Integer broj_lajkova,
                 Integer broj_pregleda,
                 Boolean radOdKuce,
                 Integer broj_prijava,
                 String pozicija,
                 Integer plata) {
        this.idOglasa = id_oglasa;
        this.opis = opis;
        this.naslov = naslov;
        this.idOglasavaca = id_oglasavaca;
        this.idKategorije = id_kategorije;
        this.idLokacije = id_lokacije;
        this.brojLajkova = broj_lajkova;
        this.brojPregleda = broj_pregleda;
        this.radOdKuce = radOdKuce;
        this.brojPrijava = broj_prijava;
        this.pozicija = pozicija;
        this.plata=plata;
    }

    public Integer getIdOglasa() {
        return idOglasa;
    }

    public void setIdOglasa(Integer id_oglasa) {
        this.idOglasa = id_oglasa;
    }

    public String getOpis() {
        return opis;
    }

    public void setOpis(String opis) {
        this.opis = opis;
    }

    public String getNaslov() {
        return naslov;
    }

    public void setNaslov(String naslov) {
        this.naslov = naslov;
    }

    public Integer getIdOglasavaca() {
        return idOglasavaca;
    }

    public void setIdOglasavaca(Integer idOglasavaca) {
        this.idOglasavaca = idOglasavaca;
    }

    public Integer getIdKategorije() {
        return idKategorije;
    }

    public void setIdKategorije(Integer idKategorije) {
        this.idKategorije = idKategorije;
    }

    public Integer getIdLokacije() {
        return idLokacije;
    }

    public void setIdLokacije(Integer idLokacije) {
        this.idLokacije = idLokacije;
    }

    public Integer getBrojLajkova() {
        return brojLajkova=lajkovi.size();
    }

    public void setBrojLajkova(Integer brojLajkova) {
        this.brojLajkova = brojLajkova;
    }

    public Integer getBrojPregleda() {
        return brojPregleda;
    }

    public void setBrojPregleda(Integer brojPregleda) {
        this.brojPregleda = brojPregleda;
    }

    public Boolean getRadOdKuce() {
        return radOdKuce;
    }

    public void setRadOdKuce(Boolean radOdKuce) {
        this.radOdKuce = radOdKuce;
    }

    public Integer getBrojPrijava() {
        System.out.println(prijave);
        return brojPrijava=prijave.size();
    }

    public void setBrojPrijava(Integer brojPrijava) {
        this.brojPrijava = brojPrijava;
    }

    public List<Prijava> getPrijave() {
        return prijave;
    }

    public void setPrijave(List<Prijava> prijave) {
        this.prijave = prijave;
    }

    public String getPozicija() {
        return pozicija;
    }

    public void setPozicija(String pozicija) {
        this.pozicija = pozicija;
    }

    public List<Lajk> getLajkovi() {
        return lajkovi;
    }

    public void setLajkovi(List<Lajk> lajkovi) {
        this.lajkovi = lajkovi;
    }

    public List<Podkategorija> getPodkategorije() {
        return podkategorije;
    }

    public void setPodkategorije(List<Podkategorija> podkategorije) {
        this.podkategorije = podkategorije;
    }

    public int getBrojKomentara(){
        return komentari.size();
    };

    public List<Komentar> getKomentari() {
        return komentari;
    }

    public void setKomentari(List<Komentar> komentari) {
        this.komentari = komentari;
    }

    public Integer getPlata() {
        return plata;
    }

    public void setPlata(Integer plata) {
        this.plata = plata;
    }
}
