
package com.example.Vezba.security;

import java.util.Collection;
import java.util.Collections;

import com.example.Vezba.model.Korisnik;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;



public class CustomUserDetails implements UserDetails {

    private Korisnik korisnik;

    public CustomUserDetails(Korisnik korisnik) {
        this.korisnik = korisnik;
    }

    @Override
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return Collections.singleton(new SimpleGrantedAuthority(korisnik.getRole()));
    }

    @Override
    public String getPassword() {
        return korisnik.getLozinka();
    }

    @Override
    public String getUsername() {
        return korisnik.getUsername();
    }

    @Override
    public boolean isAccountNonExpired() {
        return true;
    }

    @Override
    public boolean isAccountNonLocked() {
        return true;
    }

    @Override
    public boolean isCredentialsNonExpired() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        if(korisnik.getRole().equals("ROLE_NEODOBREN"))
            return false;
        return true;
    }

    public String getFullName(){
        return korisnik.getIme() + " " + korisnik.getPrezime();
    }

    public Integer getKorisnikId(){
        return korisnik.getIdKorisnika();
    }

}