package com.example.Vezba.service;

import com.example.Vezba.model.Oglas;
import com.example.Vezba.model.Podkategorija;
import com.example.Vezba.model.PodkategorijaOglasa;
import com.example.Vezba.repository.OglasRepository;
import com.example.Vezba.repository.PodkategorijaOglasaRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Service
public class PodkategorijaOglasaService implements IPodkategorijaOglasaService{

    @Autowired
    IPodkategorijaService podkategorijaService;

    @Autowired
    PodkategorijaOglasaRepository podkategorijaOglasaRepository;

    @Autowired
    OglasRepository oglasRepository;

    @Override
    public List<Podkategorija> vratiListuPodkategorijaOglasa(int id) {
        List<PodkategorijaOglasa> listaPodkategorijaOglasa = podkategorijaOglasaRepository.findByIdOglasa(id);
        List<Integer> ids=new ArrayList<Integer>();
        for(PodkategorijaOglasa po: listaPodkategorijaOglasa){
            ids.add(po.getIdPodkategorije());
        }
        return podkategorijaService.findByIdPodkategorije(ids);
    }

    @Override
    public List<Oglas> vratiListuOglasaSPodkategorijama(List<Integer> listaIdPodkategorija) {
        List<Integer> pomocna;
        Set<Oglas> skupOglasa=null;
        for(Integer idPodkategorije: listaIdPodkategorija){
            pomocna=podkategorijaOglasaRepository.findIdOglasaByIdPodkategorije(idPodkategorije);
            if(skupOglasa==null){
                skupOglasa=new HashSet<Oglas>(oglasRepository.findAllById(pomocna));
            }
            else{
                skupOglasa.retainAll(oglasRepository.findAllById(pomocna));
            }
        }
        return new ArrayList<>(skupOglasa);
    }

    @Override
    public void save(Integer oglas, Integer podkat) {
        podkategorijaOglasaRepository.save(new PodkategorijaOglasa(oglas,podkat));
    }

}
