package com.example.Vezba.controller;

import com.example.Vezba.model.*;
import com.example.Vezba.repository.KategorijaRepository;
import com.example.Vezba.repository.KorisnikRepository;
import com.example.Vezba.repository.LokacijaRepository;
import com.example.Vezba.repository.OglasRepository;
import com.example.Vezba.security.CustomUserDetails;
import com.example.Vezba.service.IPodkategorijaOglasaService;
import com.example.Vezba.service.IPodkategorijaService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import java.io.IOException;
import java.util.List;

import static java.lang.Integer.parseInt;


@Controller
public class HomeController {

    @Autowired
    private KorisnikRepository repository;

    @Autowired
    private OglasRepository oglasRepository;

    @Autowired
    private LokacijaRepository lokacijaRepository;

    @Autowired
    private KategorijaRepository kategorijaRepository;

    @Autowired
    private IPodkategorijaService podkategorijaService;

    @Autowired
    private IPodkategorijaOglasaService podkategorijaOglasaService;

    @GetMapping("/login")
    public String loginPage(){
        return "login";
    }

    @GetMapping("/admin_stranica")
    public String h123(){
        return "admin_stranica";
    }

    @GetMapping("/")
    public String home1(Model model) {
        List<Lokacija> listaLokacija = lokacijaRepository.findAll();
        model.addAttribute("listaLokacija",listaLokacija);

        return "index";
    }

    @GetMapping("/registracija")
    public String showSignUpForm(Model model,
                                 @RequestParam(name="validation", defaultValue = "") String validation){
        model.addAttribute("korisnik",new Korisnik());

        return "signup_form";
    }

    @PostMapping("/process_register")
    public String processRegistration(Korisnik korisnik,
                                      Model model,
                                      @RequestParam("slikaFile")MultipartFile slika,
                                      @RequestParam("cvFile")MultipartFile cv,
                                      RedirectAttributes ra) throws IOException {
        if(!slika.isEmpty()) {
            korisnik.setSlika(slika.getBytes());
        }
        if(!cv.isEmpty()) {
            korisnik.setCv(cv.getBytes());
        }

        List<Korisnik> listaKorisnika = repository.findAll();

        BCryptPasswordEncoder encoder = new BCryptPasswordEncoder();
        String encodedPassword = encoder.encode(korisnik.getLozinka());
        korisnik.setLozinka(encodedPassword);

        Boolean emailBool = false;
        Boolean numberBool = false;
        Boolean usernameBool = false;
        String invalid = "Uneseni podaci [";

        for(Korisnik k : listaKorisnika){
            if(!emailBool && k.getEmail().equals( korisnik.getEmail())){
                invalid+= "Email ";
                emailBool=true;
            }


            if(!numberBool && k.getTelefon().equals( korisnik.getTelefon())){
                invalid+= "Broj telefona ";
                numberBool=true;
            }


            if(!usernameBool && k.getUsername().equals( korisnik.getUsername())){
                invalid+= "Korisnicko ime ";
                usernameBool=true;
            }

        }

        invalid+= "] su vec zauzeti";

        System.out.println(emailBool);
        System.out.println(numberBool);
        System.out.println(usernameBool);

        if(emailBool==false && numberBool==false && usernameBool==false){
            repository.save(korisnik);
            ra.addFlashAttribute("message","Uspesno ste se registrovali!");
            return "redirect:/";
        }
        else
        {
            model.addAttribute("validation",invalid);
            return "signup_form";
        }

    }


    @GetMapping("/postavi_oglas")
    public String newOglas(Model model){

        List<Lokacija> listaLokacija = lokacijaRepository.findAll();
        List<Kategorija> listaKategorija = kategorijaRepository.findAll();
        List<Podkategorija> listaPodkategorija= podkategorijaService.findAll();

        model.addAttribute("oglas",new Oglas());
        model.addAttribute("listaLokacija",listaLokacija);
        model.addAttribute("listaKategorija",listaKategorija);
        model.addAttribute("listaPodkategorija",listaPodkategorija);

        return "novi_oglas";
    }

    @PostMapping("/proces_postavi_oglas")
    public String procesPostaviOglas(Oglas oglas,
                                     @RequestParam(value = "podkategorije", defaultValue = "-1") List<String> podkategorije,
                                     RedirectAttributes ra){

        oglas=oglasRepository.save(oglas);

        if(!podkategorije.get(0).equals("-1")){
            for(String s:podkategorije){
                oglas.getPodkategorije().add(podkategorijaService.findById(parseInt(s)));
            }
        }
        ra.addFlashAttribute("message","Uspesno ste postavili oglas!");

        return "redirect:/";
    }

    @GetMapping("lista_korisnika")
    public String viewUsersList(@RequestParam(name = "idKorisnika",defaultValue = "-1") Integer idKorisnika,
                                Model model){

        if(idKorisnika > 0){
            try {
                repository.deleteById(idKorisnika);
            }catch (Exception e){
                return "users";
            }
        }

        List<Korisnik> listaKorisnika = repository.findAll();
        model.addAttribute("listaKorisnika",listaKorisnika);

        return "users";
    }



    @GetMapping("/izbrisi")
    public String izbrisiKorisnika(@RequestParam(name = "idKorisnika", defaultValue = "-1") Integer idKorisnika){

        if(idKorisnika > 0){
            try {
                repository.deleteById(idKorisnika);
            }catch (Exception e){
                return "redirect:/lista_korisnika";
            }
        }

        return "redirect:/lista_korisnika";
    }

    @GetMapping("/odobri")
    public String odobriKorisnika(@RequestParam(name = "idKorisnika", defaultValue = "-1") Integer idKorisnika){

        if(idKorisnika > 0){
            try {
                repository.upadateTipById(idKorisnika);
            }catch (Exception e){
                return "redirect:/admin_zahtevi";
            }
        }

        return "redirect:/admin_zahtevi";
    }

    @GetMapping("/admin_zahtevi")
    public String adminZahtevi(Model model){
        model.addAttribute("zahtevi",repository.findByIdTipaKorisnika(4));

        return "admin_zahtevi";
    }

    @GetMapping("izbrisi_oglas")
    public String izbrisiOglas(@RequestParam(name = "idOglasa", defaultValue = "-1") Integer idOglasa){
        if(idOglasa > 0){
            try{
                oglasRepository.deleteById(idOglasa);
            }catch (Exception e){
                return "redirect:/lista_oglasa";
            }
        }

        return "redirect:/lista_oglasa";
    }

    @GetMapping("lista_oglasa")
    public String viewListOglasa(@RequestParam(name = "idOglasa",defaultValue = "-1") Integer idOglasa, Model model){
        if(idOglasa > 0){
            try{
                oglasRepository.deleteById(idOglasa);
            }catch (Exception e){
                return "lista_oglasa";
            }
        }

        List<Oglas> listaOglasa = oglasRepository.findAll();
        model.addAttribute("listaOglasa",listaOglasa);

        return "lista_oglasa";
    }

    @GetMapping("/izmena_podataka")
    public String editUser(Model model){

        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        CustomUserDetails userDetails = (CustomUserDetails) authentication.getPrincipal();

        model.addAttribute("korisnik",repository.findById(userDetails.getKorisnikId()).get());

        return "izmena_podataka";
    }

    @PostMapping("/proces_update_korisnik/{id}")
    public String updateUser(@PathVariable Integer id,
                             @ModelAttribute("korisnik") Korisnik korisnik,
                             RedirectAttributes ra,
                             Model model){

        List<Korisnik> listaKorisnika = repository.findAll();

        Korisnik existingKorisnik = repository.findById(id).get();

        Boolean emailBool = false;
        Boolean numberBool = false;
        Boolean usernameBool = false;
        String invalid = "Uneseni podaci [";

        for(Korisnik k : listaKorisnika){
            if(!emailBool && k.getEmail().equals( korisnik.getEmail()) && k.getIdKorisnika()!=id){

                invalid+= "E-mail ";
                emailBool=true;
            }


            if(!numberBool && k.getTelefon().equals( korisnik.getTelefon()) && k.getIdKorisnika()!=id){
                invalid+= "Broj telefona ";
                numberBool=true;
            }


            if(!usernameBool && k.getUsername().equals( korisnik.getUsername()) && k.getIdKorisnika()!=id){
                invalid+= "Korisnicko ime ";
                usernameBool=true;
            }
        }

        invalid+= "] su vec zauzeti";


        if(emailBool==false && numberBool==false && usernameBool==false){
            existingKorisnik.setIme(korisnik.getIme());
            existingKorisnik.setPrezime(korisnik.getPrezime());
            existingKorisnik.setUsername(korisnik.getUsername());
            existingKorisnik.setTelefon(korisnik.getTelefon());
            existingKorisnik.setEmail(korisnik.getEmail());

            BCryptPasswordEncoder encoder = new BCryptPasswordEncoder();
            String encodedPassword = encoder.encode(korisnik.getLozinka());
            existingKorisnik.setLozinka(encodedPassword);

            repository.save(existingKorisnik);
            return "redirect:/";
        }
        else
        {
            ra.addFlashAttribute("validation",invalid);
            return "redirect:/izmena_podataka";
        }
    }


}
