package com.example.Vezba.controller;

import com.example.Vezba.model.*;
import com.example.Vezba.repository.*;
import com.example.Vezba.service.IPodkategorijaOglasaService;
import com.example.Vezba.service.PodkategorijaService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;

import static java.lang.Integer.parseInt;

@Controller
public class PoslodavciController {
    @Autowired
    private OglasRepository oglasRepository;

    @Autowired
    private KorisnikRepository korisnikRepository;

    @Autowired
    private LokacijaRepository lokacijaRepository;

    @Autowired
    private KategorijaRepository kategorijaRepository;

    @Autowired
    private IPodkategorijaOglasaService podkategorijaOglasaService;

    @Autowired
    private PodkategorijaService podkategorijaService;

    @Autowired
    private OcenaRepository ocenaRepository;

    @GetMapping("/lista_poslodavaca")
    public String izlistajPoslodavce(Model model,
                                     @RequestParam MultiValueMap<String,String> parametri){

        HashSet<Korisnik> skupPoslodavaca = new HashSet(korisnikRepository.findAll());
        skupPoslodavaca.retainAll(korisnikRepository.findByIdTipaKorisnika(2));

        List<Korisnik> listaKorisnika = new ArrayList<>();

        LinkedMultiValueMap mapaParamatara=new LinkedMultiValueMap(parametri);

        //filter
        List<String> pretraga=mapaParamatara.get("pretraga");
        List<String> tip_sortiranja=mapaParamatara.get("sortBy");

        if(pretraga!=null ) {
            if(pretraga!=null && !pretraga.get(0).equals("")) {
                for(Korisnik k:korisnikRepository.findByPrezimeLike("%"+pretraga.get(0)+"%"))
                    listaKorisnika.add(k);
                for(Korisnik k:korisnikRepository.findByImeLike("%"+pretraga.get(0)+"%"))
                    listaKorisnika.add(k);

                skupPoslodavaca.retainAll(listaKorisnika);
            }

        }

        List<Korisnik> listaPoslodavaca = new ArrayList<>(skupPoslodavaca);
        if(tip_sortiranja!=null) {
            String sort = tip_sortiranja.get(0);
            switch(sort){
                case "stari":
                    listaPoslodavaca.sort(new AscendingSortById());
                    break;
                case "ocena":
                    listaPoslodavaca.sort(new SortByOcena());
                    break;
                default:
                    listaPoslodavaca.sort(new DesceningSortById());
                    break;
            }
        }
        else
            listaPoslodavaca.sort(new DesceningSortById());

        model.addAttribute("poslodavci", listaPoslodavaca);

        return "lista_poslodavaca";
    }


    @GetMapping("/poslodavac_profil")
    public String jobDetails(@RequestParam("id") String id_korisnika, Model model){

        Korisnik korisnik = korisnikRepository.findById(parseInt(id_korisnika));
        //provera da li je prosledjen id nezaposlenog
        if(korisnik.getIdTipaKorisnika()==3)
            return "redirect:/error";

        List<Oglas> listaOglasa = oglasRepository.findByIdOglasavaca(parseInt(id_korisnika));

        List<Lokacija> listaLokacija = new ArrayList<>();
        List<Kategorija> listaKategorija = new ArrayList<>();

        for (Oglas oglas : listaOglasa) {
            listaLokacija.add(lokacijaRepository.findById(oglas.getIdLokacije()).get());
            listaKategorija.add(kategorijaRepository.findById(oglas.getIdKategorije()).get());
        }

        model.addAttribute("poslodavac",korisnik);
        model.addAttribute("listaOglasa",listaOglasa);
        model.addAttribute("listaLokacija",listaLokacija);
        model.addAttribute("listaKategorija",listaKategorija);
        model.addAttribute("ocena",new Ocena());

        return "poslodavac_profil";
    }

    @PostMapping("/proces_oceni_poslodavca")
    public String oceniPoslodavca(Korisnik korisnik,
                             @RequestParam("idOcenjivaca") String idOcenjivaca,
                             @RequestParam("idPoslodavca") String idPoslodavca,
                             @RequestParam("ocena") String ocena,
                                  RedirectAttributes ra)
    {

        int test=ocenaRepository.updateOcena(parseInt(ocena),parseInt(idOcenjivaca),parseInt(idPoslodavca));
        if(test==0) {
            Ocena novaOcena = new Ocena(parseInt(ocena), parseInt(idOcenjivaca), parseInt(idPoslodavca));
            ocenaRepository.save(novaOcena);
        }

        ra.addFlashAttribute("message","Uspesno ste ocenili ovog poslodavca");

        return "redirect:/poslodavac_profil?id="+idPoslodavca;
    }

}
