package com.example.Vezba.model;

import javax.persistence.*;
import java.util.List;

@Entity
@Table(name = "kategorije")
public class Kategorija {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name="id_kategorije")
    private Integer idKategorije;

    @Column(nullable = false, unique = true, length = 45)
    private String naziv;

    @OneToMany(
            cascade = CascadeType.ALL,
            orphanRemoval = true
    )
    @JoinColumn(name="id_kategorije")
    private List<Oglas> oglasi;

    @OneToMany(
            cascade = CascadeType.ALL,
            orphanRemoval = true
    )
    @JoinColumn(name="id_kategorije")
    private List<Podkategorija> podkategorije;

    public Kategorija(){

    }

    public Kategorija(String naziv) {
        this.naziv = naziv;
    }

    public Kategorija(Integer id_kategorije, String naziv) {
        this.idKategorije = id_kategorije;
        this.naziv = naziv;
    }

    public Integer getIdKategorije() {
        return idKategorije;
    }

    public void setIdKategorije(Integer id_kategorije) {
        this.idKategorije = id_kategorije;
    }

    public String getNaziv() {
        return naziv;
    }

    public void setNaziv(String naziv) {
        this.naziv = naziv;
    }
}
