package com.example.Vezba.model;


import javax.persistence.*;

@Entity
@Table(name="komentari")
public class Komentar {

    @Id
    @Column(name="id_komentara")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer idKomentara;

    @Column(name="id_oglasa")
    private Integer idOglasa;

    @Column(name="tekst_komentara")
    private String tekstKomentara;

//    @Column(name="id_korisnika")
//    private Integer idKorisnika;

    @ManyToOne
    @JoinColumn(name = "id_korisnika")
    private Korisnik korisnik;

    public Komentar() {
    }

    public Komentar(Integer idOglasa, String tekstKomentara, Korisnik k) {
        this.idOglasa = idOglasa;
        this.tekstKomentara = tekstKomentara;
        this.korisnik = k;
    }

    public Komentar(Integer idKomentara, Integer idOglasa, String tekstKomentara, Korisnik k) {
        this.idKomentara = idKomentara;
        this.idOglasa = idOglasa;
        this.tekstKomentara = tekstKomentara;
        this.korisnik = k;
    }

    public Integer getIdKomentara() {
        return idKomentara;
    }

    public void setIdKomentara(Integer idKomentara) {
        this.idKomentara = idKomentara;
    }

    public Integer getIdOglasa() {
        return idOglasa;
    }

    public void setIdOglasa(Integer idOglasa) {
        this.idOglasa = idOglasa;
    }

    public String getTekstKomentara() {
        return tekstKomentara;
    }

    public void setTekstKomentara(String tekstKomentara) {
        this.tekstKomentara = tekstKomentara;
    }

    public Korisnik getKorisnik() {
        return korisnik;
    }

    public void setKorisnik(Korisnik korisnik) {
        this.korisnik = korisnik;
    }
}
