package com.example.Vezba.repository;

import com.example.Vezba.model.Korisnik;
import com.example.Vezba.model.Oglas;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collection;
import java.util.List;


@Repository
public interface OglasRepository extends JpaRepository<Oglas, Integer> {
    List<Oglas> findByNaslov(String naslov);

    List<Oglas> findByIdKategorije(Integer id_kategorije);

    List<Oglas> findByIdLokacije(Integer id_lokacije);

    List<Oglas> findByRadOdKuce(boolean rad_od_kuce);

    List<Oglas> findByNaslovLike(String s);

    List<Oglas> findByIdOglasavaca(Integer k);

    @Transactional
    @Modifying
    @Query("UPDATE Oglas o SET o.brojPregleda=o.brojPregleda+1 WHERE  o.idOglasa=?1")
    Integer updateBrojPregledaByIdOglasa(Integer idOglasa);

    @Transactional
    @Modifying
    @Query("UPDATE Oglas o SET o.brojLajkova=o.brojLajkova+1 WHERE  o.idOglasa=?1")
    Integer updateBrojLajkovaByIdOglasa(Integer idOglasa);

    @Transactional
    @Modifying
    @Query("UPDATE Oglas o SET o.brojPrijava=o.brojPrijava+1 WHERE  o.idOglasa=?1")
    Integer updateBrojPrijavaByIdOglasa(Integer idOglasa);

    @Query("SELECT COUNT(o.idOglasa) FROM Oglas o WHERE o.idOglasavaca=?1")
    Integer countOfOglasByIdOglasavaca(Integer idOglasavaca);

    @Query("SELECT SUM(o.brojPregleda) FROM Oglas o WHERE o.idOglasavaca=?1")
    Integer sumOfViewsByIdOglasavaca(Integer idOglasavaca);

    @Query("SELECT SUM(o.brojLajkova) FROM Oglas o WHERE o.idOglasavaca=?1")
    Integer sumOfLikesByIdOglasavaca(Integer idOglasavaca);

    @Query("SELECT SUM(o.brojPrijava) FROM Oglas o WHERE o.idOglasavaca=?1")
    Integer sumOfPrijaveByIdOglasavaca(Integer idOglasavaca);
}
