package com.example.SkuciSe.configuration.WebSocket;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Service;

@Service
public class WSService {

    private final SimpMessagingTemplate messagingTemplate;

    @Autowired
    public WSService(SimpMessagingTemplate messagingTemplate) {
        this.messagingTemplate = messagingTemplate;
    }
    public void notifyUser(final String mail, final Message message) {
        ResponseMessage responseMessage = new ResponseMessage( message.getFrom() + " " + message.getMessageContent());
        messagingTemplate.convertAndSendToUser(mail, "/topic/private-messages", responseMessage);
    }
}