package com.example.SkuciSe.controller;

import com.example.SkuciSe.configuration.EmailPostoji;
import com.example.SkuciSe.configuration.WebSocket.Message;
import com.example.SkuciSe.model.korisnik.Korisnik;
import com.example.SkuciSe.model.korisnik.KorisnikDetails;
import com.example.SkuciSe.model.oglas.Oglas;
import com.example.SkuciSe.repository.KorisnikRepository;
import com.example.SkuciSe.repository.LokacijaRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.security.Principal;
import java.util.Base64;

@Controller
public class AppController
{
    @Autowired
    KorisnikRepository kRepo;
    @Autowired
    LokacijaRepository lRepo;

    @GetMapping({"/","","/index"})
    public String getIndex(Model model, @AuthenticationPrincipal KorisnikDetails korisnik)
    {
        model.addAttribute("loggedUser", korisnik);
        model.addAttribute("lokacije", lRepo.findAll());
        model.addAttribute("filter", new Oglas());
        return("index");
    }

    @GetMapping("/login")
    public String getLogin( Model model, @AuthenticationPrincipal KorisnikDetails loggedUser)
    {
        if( loggedUser != null )
            return "redirect:/index";
        return("login");
    }

    @GetMapping("/register")
    public String getRegister( Model model, @AuthenticationPrincipal KorisnikDetails loggedUser)
    {
        if( loggedUser != null )
            return "redirect:/index";
        model.addAttribute("newUser", new Korisnik());
        model.addAttribute("lokacije", lRepo.findAll());
        return("register");
    }

    @PostMapping("/register-proccess")
    public String postRegisterProccess(@ModelAttribute Korisnik korisnik, @RequestParam("image") MultipartFile multipartFile, Model model)
    {
        System.out.println(korisnik);
        try {
            kRepo.insert( korisnik, multipartFile);
            return("redirect:/login");
        } catch (EmailPostoji e) {
            model.addAttribute("newUser", korisnik);
            model.addAttribute("lokacije", lRepo.findAll());
            model.addAttribute("emailZauzet", true);
            return("register");
        }
    }
    @GetMapping("/onama")
    public String getOnama(Model model,@AuthenticationPrincipal KorisnikDetails loggedUser)
    {
        model.addAttribute("loggedUser",loggedUser);
        return "onama";
    }

    @GetMapping("/portfolio")
    public String getPortfolio(Model model,@AuthenticationPrincipal KorisnikDetails loggedUser)
    {
        model.addAttribute("loggedUser",loggedUser);
        return "portfolio";
    }
    @GetMapping("/chat")
    public String getChat(Model model,@AuthenticationPrincipal KorisnikDetails loggedUser){
        model.addAttribute("loggedUser",loggedUser);
        return "chat";
    }
}
