package com.example.SkuciSe.controller;

import com.example.SkuciSe.model.komentar.Komentar;
import com.example.SkuciSe.model.korisnik.KorisnikDetails;
import com.example.SkuciSe.repository.KomentarRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;

@Controller
public class KomentarController
{
    @Autowired
    KomentarRepository komentarRepo;

    @PostMapping("/profile/moji-zahtevi/sacuvaj-komentar")
    public String postSacuvajKomentar(Model model, @AuthenticationPrincipal KorisnikDetails loggedUser, @ModelAttribute("komentar") Komentar komentar) throws Exception {
        komentarRepo.insert( loggedUser.getKorisnik().getKorisnikId(), komentar);
        return ("redirect:/profile/moji-zahtevi");
    }
}
