package com.example.SkuciSe.configuration.WebSocket;

import com.example.SkuciSe.model.korisnik.Korisnik;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.simp.annotation.SendToUser;
import org.springframework.stereotype.Controller;
import org.springframework.web.util.HtmlUtils;

import java.security.Principal;

@Controller
public class MessageController {

    @Autowired
    private WSService service;
    @MessageMapping("/private-message")
    @SendToUser("topic/private-messages")
    public ResponseMessage getPrivateMessage(final Message message,
                                             final Principal principal)throws InterruptedException{
        Thread.sleep(1000);
        message.setFrom( principal.getName());
        service.notifyUser( message.getTo(), message);
        return new ResponseMessage( HtmlUtils.htmlEscape(message.getFrom() + ": "+ message.getMessageContent()));
    }
}
