package com.example.SkuciSe.repository;

import com.example.SkuciSe.configuration.EmailPostoji;
import com.example.SkuciSe.model.korisnik.Korisnik;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import java.io.IOException;
import java.sql.*;
import java.util.*;

@Component
public class KorisnikRepository
{
    @Autowired
    DataBase dataBase;

    @Autowired
    LokacijaRepository lRepo;

    public void insert( Korisnik korisnik, MultipartFile multipartFile) throws EmailPostoji {
        if( this.findByEmail( korisnik.getEmail()) == null)
        {
            CallableStatement stmt = null;
            ResultSet rs = null;
             try {
                 String slika = Base64.getEncoder().encodeToString(multipartFile.getBytes());
                 String sql = "{call insertKorisnik(?,?,?,?,?,?,?,?)}";
                 //String sql = "insert into korisnik( ime, prezime, telefon, email, sifra, tipId, slika, gradid) values('"+korisnik.getIme()+"','"+korisnik.getPrezime()+"','"+korisnik.getTelefon()+"','"+korisnik.getEmail()+"','"+new BCryptPasswordEncoder().encode(korisnik.getSifra())+"',1, '"+ slika +"', "+korisnik.getGradId()+",false)";
                     stmt = dataBase.connection.prepareCall( sql);
                     stmt.setString(1,korisnik.getIme());
                     stmt.setString(2,korisnik.getPrezime());
                     stmt.setString(3,korisnik.getTelefon());
                     stmt.setString(4,korisnik.getEmail());
                     stmt.setString(5,new BCryptPasswordEncoder().encode(korisnik.getSifra()));
                     stmt.setInt(6,1);
                     stmt.setString(7,slika);
                     stmt.setInt(8,korisnik.getGradId());
                     stmt.addBatch();
                     stmt.executeBatch();
             } catch (IOException e) {
                 System.out.println(e.getMessage());
             } catch (SQLException e) {
                 System.out.println(e.getMessage());
            }
        }
        else
        {
            throw new EmailPostoji();
        }
    }

    public void update( Korisnik korisnik)
    {
        CallableStatement stmt = null;
        String sql = "{call updateKorisnik(?,?,?,?,?,?)}";
        try {
            stmt = dataBase.connection.prepareCall(sql);
            stmt.setString(1,korisnik.getIme());
            stmt.setString(2,korisnik.getPrezime());
            stmt.setString(3,korisnik.getEmail());
            stmt.setString(4,korisnik.getTelefon());
            stmt.setInt(5,korisnik.getGradId());
            stmt.setInt(6,korisnik.getKorisnikId());
            System.out.println(stmt.toString());
            stmt.execute();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void updateSlika( Korisnik korisnik, MultipartFile file)
    {
        String slika = null;
        String sql = null;
        CallableStatement cs;
        try {
             slika = Base64.getEncoder().encodeToString(file.getBytes());
             sql = "{call updateSlika(?,?)}";
             cs = dataBase.connection.prepareCall(sql);
             cs.setString(1,slika);
             cs.setInt(2,korisnik.getKorisnikId());
             cs.execute();
        } catch (SQLException e) {
            throw new RuntimeException(e);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Korisnik findByEmail(String email)
    {
        //String sql = "select * from korisnik where email = '"+email+"'";
        String sql = "{call findByEmail(?)}";
        ResultSet rs = null;
        CallableStatement stmt = null;
        try {
            stmt = dataBase.connection.prepareCall(sql);
            stmt.setString(1, email);
            rs = stmt.executeQuery();
            while( rs.next())
            {
                return ( new Korisnik( rs.getInt("korisnikId"), rs.getString("ime"), rs.getString("prezime"), rs.getString("email"), rs.getString("sifra"), rs.getString("telefon"), rs.getString("slika"), rs.getInt("tipid"), rs.getInt("gradid"), rs.getBoolean("enabled")));
            }
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return( null);
    }

    public Korisnik findById(Integer id){
        String sql = "{call findKorisnikById(?)}";
        ResultSet rs = null;
        CallableStatement stmt = null;
        try {
            stmt = dataBase.connection.prepareCall(sql);
            stmt.setInt(1, id);
            rs = stmt.executeQuery();
            while( rs.next())
            {
                return ( new Korisnik( rs.getInt("korisnikId"), rs.getString("ime"), rs.getString("prezime"), rs.getString("email"), rs.getString("sifra"), rs.getString("telefon"), rs.getString("slika"), rs.getInt("tipid"), rs.getInt("gradid"), rs.getBoolean("enabled")));
            }
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return( null);
    }

    public String findRoleById( int tipid)
    {
        String sql = "{call findRoleById(?)}";
        ResultSet rs = null;
        CallableStatement stmt = null;
        try {
            stmt = dataBase.connection.prepareCall(sql);
            stmt.setInt(1, tipid);
            rs = stmt.executeQuery();
            while( rs.next())
            {
                return rs.getString("naziv");
            }
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return( null);
    }

    public List<Korisnik> findAll()
    {
        CallableStatement stmt = null;
        ResultSet rs = null;
        try {
            String sql = "{ call findAllKorisnik}";
            stmt = dataBase.connection.prepareCall( sql);
            List<Korisnik> list = new ArrayList<Korisnik>();
            rs = stmt.executeQuery();
            while (rs.next()) {
                list.add( new Korisnik( rs.getInt("korisnikId"), rs.getString("ime"), rs.getString("prezime"), rs.getString("email"), rs.getString("sifra"), rs.getString("telefon"), rs.getString("slika"), rs.getInt("tipid"), rs.getInt("gradid"), rs.getBoolean("enabled")));
            }
            return list;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public String findCity(Integer id){
        String sql = "{call findCityById(?)";
        ResultSet rs = null;
        CallableStatement stmt = null;
        try {
            stmt = dataBase.connection.prepareCall(sql);
            stmt.setInt(1, id);
            rs = stmt.executeQuery();
            if(rs.next())
                return rs.getString("Naziv");
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return "Nema grada";
    }

    public void deleteUser(Integer id){
        String sql = "{call deleteKorisnik(?)}";
        CallableStatement stmt = null;
        try {
            stmt = dataBase.connection.prepareCall(sql);
            stmt.setInt(1, id);
            stmt.execute();
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void updateSifra( Korisnik korisnik, int korisnikId)
    {
        String sql = "{call updateSifraKorisnika(?,?)}";
        CallableStatement stmt = null;
        try {
            stmt = dataBase.connection.prepareCall(sql);
            stmt.setString(1, new BCryptPasswordEncoder().encode( korisnik.getSifra()));
            stmt.setInt(2, korisnikId);
            stmt.execute();
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void enableKorisnik( int korisnikId)
    {
        String sql = "call enableKorisnik(?)";
        CallableStatement stmt = null;
        try {
            stmt = dataBase.connection.prepareCall(sql);
            stmt.setInt(1, korisnikId);
            stmt.execute();
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}
