package com.example.SkuciSe.repository;

import com.example.SkuciSe.model.oglas.Oglas;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.sql.*;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;

@Component
public class OglasRepository
{
    @Autowired
    DataBase dataBase;

    public void insert( int korisnikId, Oglas newOglas, MultipartFile[] files)
    {
        int oglasId;
        //String sql = "{ call insertOglas(?,?,?,?,?,?,?,?,?,?,?,?)}";
        String sql = "insert into oglas( korisnikID, naslov, opis, lokacijaId, cena, vrstaoglasaid, kvadratura, brojsoba, namesten, grejanje, lift, lokacija) values(?,?,?,?,?,?,?,?,?,?,?,?);";
        PreparedStatement stmt = null;
        try {
            stmt = dataBase.connection.prepareStatement( sql, Statement.RETURN_GENERATED_KEYS);
            stmt.setInt(1,korisnikId);
            stmt.setString(2,newOglas.getNaslov());
            stmt.setString(3,newOglas.getOpis());
            stmt.setInt(4,newOglas.getLokacijaId());
            stmt.setDouble(5,newOglas.getCena());
            stmt.setInt(6,newOglas.getVrstaOglasaId());
            stmt.setDouble(7,newOglas.getKvadratura());
            stmt.setInt(8,newOglas.getBrojSoba());
            stmt.setBoolean(9,newOglas.isNamesten());
            stmt.setBoolean(10,newOglas.isGrejanje());
            stmt.setBoolean(11,newOglas.isLift());
            stmt.setString(12,newOglas.getLokacija());
            stmt.addBatch();
            stmt.executeBatch();
            ResultSet rs = stmt.getGeneratedKeys();
            if( rs.next()) {
                oglasId = rs.getInt(1);
                for( MultipartFile file: files)
                {
                    sql = "insert into Slike( oglasid, slika)";
                    String filename = Base64.getEncoder().encodeToString( file.getBytes());
                    sql += " values ("+oglasId+",'"+filename+"')";
                    dataBase.statement.executeUpdate( sql);
                }
            }
        } catch (SQLException e) {
            throw new RuntimeException(e);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }


    }

    public List<Oglas> findAll( )
    {
        List<Oglas> list = new ArrayList<Oglas>();
        String sql = "select * from oglas";
        ResultSet rs = null;
        try {
            rs = dataBase.statement.executeQuery( sql);
            while( rs.next())
            {
                Oglas oglas =  new Oglas( rs.getInt("oglasId"), rs.getInt("korisnikId"), rs.getString("naslov"),rs.getString("opis"),rs.getInt("lokacijaId"),rs.getDouble("cena"),rs.getInt("vrstaOglasaId"),rs.getDouble("kvadratura"),rs.getInt("brojSoba"),rs.getBoolean("namesten"),rs.getBoolean("grejanje"),rs.getBoolean("lift"),rs.getString("lokacija"));
                list.add( oglas);
            }
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return( list);
    }

    public Oglas findById(int oglasId)
    {
        String sql = "select * from oglas where oglasid = " + oglasId;
        ResultSet rs = null;
        try {
            rs = dataBase.statement.executeQuery( sql);
            while( rs.next())
            {
                Oglas oglas = new Oglas( rs.getInt("oglasId"), rs.getInt("korisnikId"), rs.getString("naslov"),rs.getString("opis"),rs.getInt("lokacijaId"),rs.getDouble("cena"),rs.getInt("vrstaOglasaId"),rs.getDouble("kvadratura"),rs.getInt("brojSoba"),rs.getBoolean("namesten"),rs.getBoolean("grejanje"),rs.getBoolean("lift"),rs.getString("lokacija"));
                return oglas;
            }
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return( null);
    }

    public List<Oglas> findAllByKorisnikId( int korisnikId)
    {
        List<Oglas> list = new ArrayList<Oglas>();
        String sql = "select * from oglas where korisnikid = " + korisnikId;
        ResultSet rs = null;
        try {
            rs = dataBase.statement.executeQuery( sql);
            while( rs.next())
            {
                Oglas oglas =  new Oglas( rs.getInt("oglasId"), rs.getInt("korisnikId"), rs.getString("naslov"),rs.getString("opis"),rs.getInt("lokacijaId"),rs.getDouble("cena"),rs.getInt("vrstaOglasaId"),rs.getDouble("kvadratura"),rs.getInt("brojSoba"),rs.getBoolean("namesten"),rs.getBoolean("grejanje"),rs.getBoolean("lift"),rs.getString("lokacija"));
                list.add( oglas);
            }
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return( list);
    }

    public void deleteOglasi(Integer id)
    {
        String sql = "select * from oglas where korisnikid = " + id;
        ResultSet rs = null;
        try {
            rs = dataBase.statement.executeQuery( sql);
            while( rs.next())
            {
                int oglasid = rs.getInt("oglasid");
                this.deleteSlike( oglasid);
            }
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }

        sql = "delete from oglas where KorisnikId = "+id;
        try {
            dataBase.statement.execute(sql);
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
    public void deleteSlike(Integer id)
    {
        String sql = "delete from slike where oglasid = "+id;
        try {
            dataBase.statement.execute(sql);
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}