package com.example.SkuciSe.controller;

import com.example.SkuciSe.model.korisnik.Korisnik;
import com.example.SkuciSe.model.korisnik.KorisnikDetails;
import com.example.SkuciSe.repository.KorisnikRepository;
import com.example.SkuciSe.repository.LokacijaRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.Base64;

@Controller
public class ProfileController
{
    @Autowired
    KorisnikRepository kRepo;

    @Autowired
    LokacijaRepository lRepo;

    @GetMapping("/profile")
    public String getProfile(Model model, @AuthenticationPrincipal KorisnikDetails loggedUser)
    {
        model.addAttribute("loggedUser", loggedUser);
        model.addAttribute("editUser", loggedUser.getKorisnik());
        model.addAttribute("profileRole", kRepo.findRoleById( loggedUser.getKorisnik().getTipId()));
        model.addAttribute("grad", lRepo.findById( loggedUser.getKorisnik().getGradId()));
        model.addAttribute("lokacije", lRepo.findAll());
        return("profile");
    }

    @GetMapping("/profile-edit")
    public String getProfileEdit(Model model, @ModelAttribute Korisnik korisnik, @AuthenticationPrincipal KorisnikDetails loggedUser)
    {
        model.addAttribute("loggedUser", loggedUser);
        model.addAttribute("editUser", loggedUser.getKorisnik());
        model.addAttribute("lokacije", lRepo.findAll());
        return "/profile-edit";
    }
    @PostMapping("/profile-edit-save")
    public String postProfileEditSave(Model model, @ModelAttribute Korisnik korisnik, @AuthenticationPrincipal KorisnikDetails loggedUser)
    {
        kRepo.update( korisnik);
        loggedUser.setKorisnik( korisnik);
        return "redirect:/profile";
    }

    @PostMapping("/profile-picture-update")
    public String izmeniSliku(@AuthenticationPrincipal KorisnikDetails loggedUser,@RequestParam("image") MultipartFile file) {
        kRepo.updateSlika(loggedUser.getKorisnik(),file);
        try {
            loggedUser.setKorisnikSlika( Base64.getEncoder().encodeToString(file.getBytes()));
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return "redirect:/profile";
    }

    @GetMapping("/password-edit")
    public String getProfilePasswordEdit(Model model, @ModelAttribute Korisnik korisnik, @AuthenticationPrincipal KorisnikDetails loggedUser)
    {
        model.addAttribute("loggedUser", loggedUser);
        model.addAttribute("editUser", loggedUser.getKorisnik());
        return "/password-edit";
    }
    @PostMapping("/password-edit-save")
    public String postPasswordEditSave(Model model, @ModelAttribute Korisnik korisnik, @AuthenticationPrincipal KorisnikDetails loggedUser)
    {
        System.out.println(korisnik.toString());
        kRepo.updateSifra( korisnik, loggedUser.getKorisnik().getKorisnikId());
        loggedUser.setKorisnikSifra( korisnik.getSifra());
        return "redirect:/index";
    }
}
