package com.example.SkuciSe.repository;

import com.example.SkuciSe.model.komentar.Komentar;
import com.example.SkuciSe.model.komentar.KomentarVlasnik;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

@Component
public class KomentarVlasnikRepository
{
    @Autowired
    DataBase dataBase;

    public void insert(int vlasnikId, int korisnikId, int ocenaRadio, String text)
    {
        CallableStatement stmt = null;
        ResultSet rs = null;
        try {
            String sql = "{call insertKomentarVlasnik(?,?,?,?)}";
            stmt = dataBase.connection.prepareCall(sql);
            stmt.setInt(1, vlasnikId);
            stmt.setInt(2,korisnikId);
            stmt.setInt(3,ocenaRadio);
            stmt.setString(4,text);
            stmt.execute();
        } catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public List<KomentarVlasnik> findAllKomentarVlasnikByKorisnikID(int korisnikId)
    {
        List<KomentarVlasnik> komentari = new ArrayList<KomentarVlasnik>();
        CallableStatement cs = null;
        String sql = "{ call findAllKomentarVlasnikByKorisnikID(?)}";
        ResultSet rs = null;
        try {
            cs = dataBase.connection.prepareCall( sql);
            cs.setInt( 1, korisnikId);
            rs = cs.executeQuery();
            while( rs.next())
            {
                komentari.add( new KomentarVlasnik( rs.getInt(1),rs.getInt(2),rs.getInt(3),rs.getInt(4),rs.getString(5),rs.getString(6),rs.getString(7)));
            }
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return( komentari);
    }

    public void deleteKomentarVlasnikByKorisnikId(Integer id) throws RuntimeException
    {
        String sql = "{call deleteKomentarVlasnikByKorisnikId(?)}";
        CallableStatement stmt = null;
        try {
            stmt = dataBase.connection.prepareCall(sql);
            stmt.setInt(1,id);
            stmt.execute();
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}
