package com.example.SkuciSe.repository;

import com.example.SkuciSe.model.komentar.Lajk;
import com.example.SkuciSe.model.korisnik.Korisnik;
import com.example.SkuciSe.model.oglas.Oglas;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

import javax.xml.crypto.Data;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Base64;

@Component
public class LajkRepository {

    @Autowired
    DataBase dataBase;

    public void updateLajk(Lajk lajk)
    {
        if(this.isLiked(lajk))
        {
            System.out.println("delete "+ lajk.toString());
            this.deleteLajk(lajk);
        }
        else
        {
            System.out.println("insert "+ lajk.toString());
            this.insertLajk(lajk);
        }
    }

    public void insertLajk(Lajk lajk){
        CallableStatement stmt = null;
        try {
            String sql = "{call insertLajk(?,?)}";
            stmt = dataBase.connection.prepareCall( sql);
            stmt.setInt(1, lajk.getKorisnikId());
            stmt.setInt(2, lajk.getOglasId());
            stmt.execute();
        } catch (SQLException e) {
            System.out.println(e.getMessage());
        }
    }

    public void deleteLajk(Lajk lajk){
        CallableStatement stmt = null;
        try {
            String sql = "{call deleteLajk(?,?)}";
            stmt = dataBase.connection.prepareCall( sql);
            stmt.setInt(1, lajk.getOglasId());
            stmt.setInt(2, lajk.getKorisnikId());
            stmt.execute();
        } catch (SQLException e) {
            System.out.println(e.getMessage());
        }
    }

    public void deleteLajkByOglasId(int oglasId)
    {
        CallableStatement stmt=null;
        try {
            String sql = "{call deleteLajkByOglasId(?)}";
            stmt = dataBase.connection.prepareCall( sql);
            stmt.setInt(1, oglasId);
            stmt.execute();
        } catch (SQLException e) {
            System.out.println(e.getMessage());
        }
    }

    public void deleteLajkByKorisnikId(int korisnikId)
    {
        CallableStatement stmt=null;
        try {
            String sql = "{call deleteLajkByKorisnikId(?)}";
            stmt = dataBase.connection.prepareCall( sql);
            stmt.setInt(1, korisnikId);
            stmt.execute();
        } catch (SQLException e) {
            System.out.println(e.getMessage());
        }
    }

    public boolean isLiked(Lajk lajk)
    {
        CallableStatement stmt=null;
        ResultSet rs=null;
        try {
            String sql = "{call isLiked(?,?)}";
            stmt = dataBase.connection.prepareCall( sql);
            stmt.setInt(1, lajk.getOglasId());
            stmt.setInt(2, lajk.getKorisnikId());
            rs=stmt.executeQuery();
            while(rs.next())
            {
                if(rs.getInt(1)>0)
                {
                    return true;
                }
                else
                {
                    return false;
                }
            }
        } catch (SQLException e) {
            System.out.println(e.getMessage());
        }
        return false;
    }

    public int countLajks(int oglasId)
    {
        CallableStatement stmt=null;
        ResultSet rs=null;
        try {
            String sql = "{call countLajks(?)}";
            stmt = dataBase.connection.prepareCall( sql);
            stmt.setInt(1,oglasId);
            rs=stmt.executeQuery();
            while(rs.next())
            {
                return(rs.getInt(1));
            }
        } catch (SQLException e) {
            System.out.println(e.getMessage());
        }
        return 0;
    }
}
