package com.example.SkuciSe.repository;

import com.example.SkuciSe.model.oglas.Oglas;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.sql.*;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;

@Component
public class OglasRepository
{
    @Autowired
    DataBase dataBase;

    public void insert( int korisnikId, Oglas newOglas, MultipartFile[] files)
    {
        int oglasId;
        //String sql = "{ call insertOglas(?,?,?,?,?,?,?,?,?,?,?,?)}";
        String sql = "insert into oglas( korisnikID, naslov, opis, lokacijaId, cena, vrstaoglasaid, kvadratura, brojsoba, namesten, grejanje, lift, lokacija) values(?,?,?,?,?,?,?,?,?,?,?,?);";
        PreparedStatement stmt = null;
        try {
            stmt = dataBase.connection.prepareStatement( sql, Statement.RETURN_GENERATED_KEYS);
            stmt.setInt(1,korisnikId);
            stmt.setString(2,newOglas.getNaslov());
            stmt.setString(3,newOglas.getOpis());
            stmt.setInt(4,newOglas.getLokacijaId());
            stmt.setDouble(5,newOglas.getCena());
            stmt.setInt(6,newOglas.getVrstaOglasaId());
            stmt.setDouble(7,newOglas.getKvadratura());
            stmt.setInt(8,newOglas.getBrojSoba());
            stmt.setBoolean(9,newOglas.isNamesten());
            stmt.setBoolean(10,newOglas.isGrejanje());
            stmt.setBoolean(11,newOglas.isLift());
            stmt.setString(12,newOglas.getLokacija());
            stmt.addBatch();
            stmt.executeBatch();
            ResultSet rs = stmt.getGeneratedKeys();
            if( rs.next()) {
                oglasId = rs.getInt(1);
                for( MultipartFile file: files)
                {
                    sql = "insert into Slike( oglasid, slika)";
                    String filename = Base64.getEncoder().encodeToString( file.getBytes());
                    sql += " values ("+oglasId+",'"+filename+"')";
                    dataBase.statement.executeUpdate( sql);
                }
            }
        } catch (SQLException e) {
            throw new RuntimeException(e);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }


    }

    public Oglas findById(int oglasId)
    {
        String sql = "{ call findOglasbyId(?)}";
        CallableStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dataBase.connection.prepareCall( sql);
            stmt.setInt( 1, oglasId);
            rs = stmt.executeQuery();
            while( rs.next())
            {
                Oglas oglas = new Oglas( rs.getInt("oglasId"), rs.getInt("korisnikId"), rs.getString("naslov"),rs.getString("opis"),rs.getInt("lokacijaId"),rs.getDouble("cena"),rs.getInt("vrstaOglasaId"),rs.getDouble("kvadratura"),rs.getInt("brojSoba"),rs.getBoolean("namesten"),rs.getBoolean("grejanje"),rs.getBoolean("lift"),rs.getString("lokacija"));
                return oglas;
            }
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return( null);
    }

    public void deleteOglasi(Integer id)
    {
        String sql = "{call findAllByKorisnikId(?)}";
        CallableStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dataBase.connection.prepareCall( sql);
            stmt.setInt(1,id);
            rs = stmt.executeQuery();
            while( rs.next())
            {
                int oglasid = rs.getInt("oglasid");
                this.deleteSlike( oglasid);
            }
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }

        sql = "{call deleteOglasiByKorisnikId(?)}";
        CallableStatement stmt1 = null;
        try {
            stmt1 = dataBase.connection.prepareCall( sql);
            stmt1.setInt(1, id);
            stmt1.execute();
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
    public void deleteSlike(Integer id)
    {
        String sql = "{call deleteSlike(?)}";
        CallableStatement cs = null;
        try {
            cs = dataBase.connection.prepareCall(sql);
            cs.setInt(1, id);
            cs.execute();
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Oglas> findAll(Integer vrstaOglasaId, Integer lokacijaId, Integer brojSoba, Double cenaMin, Double cenaMax, Double kvadraturaMin, Double kvadraturaMax, Boolean lift, Boolean grejanje, Boolean namesten, String pretraga)
    {
        List<Oglas> list = new ArrayList<Oglas>();
        String sql = "{call findAll()}";
        ResultSet rs = null;
        CallableStatement stmt = null;
        try {
            stmt = dataBase.connection.prepareCall(sql);
            rs = stmt.executeQuery();
            while( rs.next())
            {
                Oglas oglas =  new Oglas( rs.getInt("oglasId"), rs.getInt("korisnikId"), rs.getString("naslov"),rs.getString("opis"),rs.getInt("lokacijaId"),rs.getDouble("cena"),rs.getInt("vrstaOglasaId"),rs.getDouble("kvadratura"),rs.getInt("brojSoba"),rs.getBoolean("namesten"),rs.getBoolean("grejanje"),rs.getBoolean("lift"),rs.getString("lokacija"));

                if(!( vrstaOglasaId == null || ( vrstaOglasaId != null && vrstaOglasaId == oglas.getVrstaOglasaId() ) ) ) continue;
                if(!( lokacijaId == null || ( lokacijaId != null && lokacijaId == oglas.getLokacijaId() ) ) ) continue;

                if(!( cenaMin == null || ( cenaMin != null && cenaMin <= oglas.getCena() ) ) ) continue;
                if(!( cenaMax == null || ( cenaMax != null && cenaMax >= oglas.getCena() ) ) ) continue;

                if(!( brojSoba == null || ( brojSoba != null && brojSoba <= oglas.getBrojSoba() ) ) ) continue;

                if(!( kvadraturaMin == null || ( kvadraturaMin != null && kvadraturaMin <= oglas.getKvadratura() ) ) ) continue;
                if(!( kvadraturaMax == null || ( kvadraturaMax != null && kvadraturaMax >= oglas.getKvadratura() ) ) ) continue;

                if(!( lift == null || ( lift != null && lift == oglas.isLift() ) ) ) continue;
                if(!( grejanje == null || ( grejanje != null && grejanje == oglas.isGrejanje() ) ) ) continue;
                if(!( namesten == null || ( namesten != null && namesten == oglas.isNamesten() ) ) ) continue;

                if(!( pretraga == null || ( pretraga != null && (oglas.getNaslov().toLowerCase().indexOf( pretraga.toLowerCase())!=-1 || oglas.getOpis().toLowerCase().indexOf( pretraga.toLowerCase())!=-1)) ) ) continue;

                list.add( oglas);
            }
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return( list);
    }

    public List<Oglas> findAllByKorisnikId(int korisnikId, Integer vrstaOglasaId, Integer lokacijaId, Integer brojSoba, Double cenaMin, Double cenaMax, Double kvadraturaMin, Double kvadraturaMax, Boolean lift, Boolean grejanje, Boolean namesten, String pretraga)
    {
        List<Oglas> list = new ArrayList<Oglas>();
        String sql = "{call findAllByKorisnikId(?)}";
        ResultSet rs = null;
        CallableStatement stmt = null;
        try {
            stmt = dataBase.connection.prepareCall(sql);
            stmt.setInt(1,korisnikId);
            rs = stmt.executeQuery();
            while( rs.next())
            {
                Oglas oglas =  new Oglas( rs.getInt("oglasId"), rs.getInt("korisnikId"), rs.getString("naslov"),rs.getString("opis"),rs.getInt("lokacijaId"),rs.getDouble("cena"),rs.getInt("vrstaOglasaId"),rs.getDouble("kvadratura"),rs.getInt("brojSoba"),rs.getBoolean("namesten"),rs.getBoolean("grejanje"),rs.getBoolean("lift"),rs.getString("lokacija"));

                if(!( vrstaOglasaId == null || ( vrstaOglasaId != null && vrstaOglasaId == oglas.getVrstaOglasaId() ) ) ) continue;
                if(!( lokacijaId == null || ( lokacijaId != null && lokacijaId == oglas.getLokacijaId() ) ) ) continue;

                if(!( cenaMin == null || ( cenaMin != null && cenaMin <= oglas.getCena() ) ) ) continue;
                if(!( cenaMax == null || ( cenaMax != null && cenaMax >= oglas.getCena() ) ) ) continue;

                if(!( brojSoba == null || ( brojSoba != null && brojSoba <= oglas.getBrojSoba() ) ) ) continue;

                if(!( kvadraturaMin == null || ( kvadraturaMin != null && kvadraturaMin <= oglas.getKvadratura() ) ) ) continue;
                if(!( kvadraturaMax == null || ( kvadraturaMax != null && kvadraturaMax >= oglas.getKvadratura() ) ) ) continue;

                if(!( lift == null || ( lift != null && lift == oglas.isLift() ) ) ) continue;
                if(!( grejanje == null || ( grejanje != null && grejanje == oglas.isGrejanje() ) ) ) continue;
                if(!( namesten == null || ( namesten != null && namesten == oglas.isNamesten() ) ) ) continue;

                if(!( pretraga == null || ( pretraga != null && oglas.getNaslov().toLowerCase().contains( pretraga.toLowerCase()) ) ) ) continue;
                else if(!( pretraga == null || ( pretraga != null && oglas.getOpis().toLowerCase().contains( pretraga.toLowerCase()) ) ) ) continue;

                System.out.println( oglas.toString());
                list.add( oglas);
            }
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return( list);
    }
}