package com.example.SkuciSe.controller;

import com.example.SkuciSe.model.korisnik.KorisnikDetails;
import com.example.SkuciSe.model.oglas.Oglas;
import com.example.SkuciSe.repository.KorisnikRepository;
import com.example.SkuciSe.repository.LokacijaRepository;
import com.example.SkuciSe.repository.OglasRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class OglasController
{
    @Autowired
    LokacijaRepository lRepo;

    @Autowired
    KorisnikRepository kRepo;

    @Autowired
    OglasRepository oRepo;

    @GetMapping("/novi-oglas")
    public String getNoviOglas(Model model, @AuthenticationPrincipal KorisnikDetails loggedUser)
    {
        model.addAttribute("loggedUser", loggedUser);
        model.addAttribute("newOglas", new Oglas());
        model.addAttribute("lokacije", lRepo.findAll());
        return("novi-oglas-form");
    }

    @PostMapping("/novi-oglas/save")
    public String postSaveNoviOglas( @ModelAttribute("newOglas") Oglas newOglas,  @RequestParam("images") MultipartFile[] files)
    {
        oRepo.insert( newOglas, files);
        return("redirect:/profile");
    }
}
