package com.example.SkuciSe.controller;

import com.example.SkuciSe.model.zahtev.Zahtev;
import com.example.SkuciSe.repository.KomentarRepository;
import com.example.SkuciSe.repository.KomentarVlasnikRepository;
import com.example.SkuciSe.repository.ZahtevRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class KomentarController {
    @Autowired
    KomentarRepository komentarRepo;
    @Autowired
    ZahtevRepository zRepo;
    @Autowired
    KomentarVlasnikRepository komentarVlasnikRepo;
    @GetMapping("/profile/moji-zahtevi/sacuvaj-komentar")
    public String postSacuvajKomentar(@RequestParam("korisnikId") int korisnikId,
                                      @RequestParam("oglasId") int oglasId,
                                      @RequestParam("zahtevId") int zahtevId,
                                      @RequestParam("ocenaRadio") int ocenaRadio,
                                      @RequestParam("komentar") String text)
    {
        try {
            komentarRepo.insert(korisnikId, oglasId, text, ocenaRadio);
            zRepo.zahtevKorisnikKom( zahtevId);
            Zahtev zahtev = zRepo.findZahtevById( zahtevId);
            if( zahtev.getKorisnikKom() && zahtev.getVlasnikKom())
                zRepo.deleteZahtev( zahtevId);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ("redirect:/profile/moji-zahtevi");
    }

    @GetMapping("/oceni-korisnika")
    public String getOceniKorisnika(@RequestParam("vlasnikId") int vlasnikId,
                                    @RequestParam("korisnikId") int korisnikId,
                                    @RequestParam("zahtevId") int zahtevId,
                                    @RequestParam("ocenaRadio") int ocenaRadio,
                                    @RequestParam("komentar") String text)
    {
        try {
            komentarVlasnikRepo.insert( vlasnikId, korisnikId, ocenaRadio, text);
            zRepo.zahtevVlasnikKom( zahtevId);
            Zahtev zahtev = zRepo.findZahtevById( zahtevId);
            if( zahtev.getKorisnikKom() && zahtev.getVlasnikKom())
                zRepo.deleteZahtev( zahtevId);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ("redirect:/profile/moji-zahtevi");
    }
}
