package com.example.SkuciSe.controller;

import com.example.SkuciSe.configuration.AktivanZahtevPostoji;
import com.example.SkuciSe.model.komentar.Komentar;
import com.example.SkuciSe.model.korisnik.Korisnik;
import com.example.SkuciSe.model.korisnik.KorisnikDetails;
import com.example.SkuciSe.model.oglas.Oglas;
import com.example.SkuciSe.model.zahtev.StanjeZahteva;
import com.example.SkuciSe.model.zahtev.Zahtev;
import com.example.SkuciSe.repository.KorisnikRepository;
import com.example.SkuciSe.repository.OglasRepository;
import com.example.SkuciSe.repository.SlikeRepository;
import com.example.SkuciSe.repository.ZahtevRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Controller
public class ZahtevController {

    @Autowired
    ZahtevRepository zRepo;
    @Autowired
    OglasRepository oRepo;
    @Autowired
    SlikeRepository sRepo;
    @Autowired
    KorisnikRepository kRepo;

    @GetMapping("/profile/moji-zahtevi")
    public String getMojiZahtevi(Model model, @AuthenticationPrincipal KorisnikDetails loggedUser)
    {
        List<Zahtev> mojiZahtevi = zRepo.findAllByKorisnikId( loggedUser.getKorisnik().getKorisnikId());
        List<Oglas> mojiOglasi = new ArrayList<Oglas>();
        List<Korisnik> vlasnici = new ArrayList<Korisnik>();
        for( Zahtev zahtev: mojiZahtevi)
        {
            Oglas oglas = oRepo.findById(zahtev.getOglasId());
            mojiOglasi.add( oglas);
            vlasnici.add( kRepo.findById( oglas.getKorisnikId()));
        }
        model.addAttribute("loggedUser", loggedUser);
        model.addAttribute("zahtevi", mojiZahtevi);
        model.addAttribute("oglasi", mojiOglasi);
        model.addAttribute("vlasnici", vlasnici);
        model.addAttribute("slike",sRepo.findAllFirstPics(mojiOglasi));
        return "moji-zahtevi";
    }

    @PostMapping("/obradi-zahtev/{id}")
    public String postObradizahtev(Model model, @AuthenticationPrincipal KorisnikDetails loggedUser, @ModelAttribute Zahtev noviZahtev, @ModelAttribute("datumIVreme") String datumIVreme, @PathVariable("id") int oglasId, RedirectAttributes redirectAttributes)
    {
        try {
            zRepo.insert( loggedUser.getKorisnik().getKorisnikId(), oglasId, noviZahtev, datumIVreme);
            redirectAttributes.addFlashAttribute("zakazan",true);
        } catch (AktivanZahtevPostoji e) {
            redirectAttributes.addFlashAttribute("aktivanZahtevPostoji",true);
        }
        return "redirect:/lista-oglasa/"+oglasId;
    }

    @GetMapping("/login-zahtev/{oglasId}")
    public String getLoginZahtev( @PathVariable("oglasId") int oglasId)
    {
        return "redirect:/lista-oglasa/"+oglasId;
    }

    @GetMapping("/oglas-edit/{oglasId}/prihvati-zahtev/{zahtevId}")
    public String getPrihvatiZahtev( Model model, @PathVariable("oglasId") int oglasId, @PathVariable("zahtevId") int zahtevId)
    {
        zRepo.updateZahtevStatus( zahtevId, StanjeZahteva.POTVRDJEN);
        return ("redirect:/lista-oglasa/" + oglasId);
    }

    @GetMapping("/oglas-edit/{oglasId}/odbi-zahtev/{zahtevId}")
    public String getOdbiZahtev( Model model, @PathVariable("oglasId") int oglasId, @PathVariable("zahtevId") int zahtevId)
    {
        zRepo.updateZahtevStatus( zahtevId, StanjeZahteva.ODBIJEN);
        return ("redirect:/lista-oglasa/" + oglasId);
    }

    @GetMapping("/oglas-edit/{oglasId}/obrisi-zahtev/{zahtevId}")
    public String getObrisiZahtev( Model model, @PathVariable("oglasId") int oglasId, @PathVariable("zahtevId") int zahtevId)
    {
        zRepo.deleteZahtev( zahtevId);
        return ("redirect:/lista-oglasa/" + oglasId);
    }
}
