package com.example.SkuciSe.controller;

import com.example.SkuciSe.model.korisnik.KorisnikDetails;
import com.example.SkuciSe.repository.KorisnikRepository;
import com.example.SkuciSe.repository.LokacijaRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;

@Controller
public class AdminController
{
    @Autowired
    KorisnikRepository kRepo;
    @Autowired
    LokacijaRepository lRepo;

    @GetMapping("/lista-korisnika")
    public String getListaKorisnika(Model model, @AuthenticationPrincipal KorisnikDetails loggedUser)
    {
        if( !kRepo.findRoleById( loggedUser.getKorisnik().getTipId()).equals( "Administrator") )
        {
            return "redirect:/index";
        }
        model.addAttribute("korisnici", kRepo.findAll());
        model.addAttribute("loggedUser", loggedUser);
        return "/lista-korisnika";
    }
}
