package com.example.SkuciSe.controller;

import com.example.SkuciSe.model.korisnik.Korisnik;
import com.example.SkuciSe.model.korisnik.KorisnikDetails;
import com.example.SkuciSe.repository.KorisnikRepository;
import com.example.SkuciSe.repository.LokacijaRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.Base64;

@Controller
public class AppController
{
    @Autowired
    KorisnikRepository kRepo;
    @Autowired
    LokacijaRepository lRepo;

    @GetMapping({"/","","/index"})
    public String getIndex(Model model, @AuthenticationPrincipal KorisnikDetails korisnik)
    {
        model.addAttribute("loggedUser", korisnik);
        return("index");
    }

    @GetMapping("/login")
    public String getLogin( Model model, @AuthenticationPrincipal KorisnikDetails loggedUser)
    {
        if( loggedUser != null )
            return "redirect:/index";
        return("login");
    }

    @GetMapping("/register")
    public String getRegister( Model model, @AuthenticationPrincipal KorisnikDetails loggedUser)
    {
        if( loggedUser != null )
            return "redirect:/index";
        model.addAttribute("newUser", new Korisnik());
        model.addAttribute("lokacije", lRepo.findAll());
        return("register");
    }

    @PostMapping("/register-proccess")
    public String postRegisterProccess(@ModelAttribute Korisnik korisnik, @RequestParam("image") MultipartFile multipartFile)
    {
        System.out.println(korisnik);
        try {
            kRepo.insert( korisnik, multipartFile);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return("redirect:/login");
    }

    @GetMapping("/profile")
    public String getProfile(Model model, @AuthenticationPrincipal KorisnikDetails loggedUser)
    {
        model.addAttribute("loggedUser", loggedUser);
        model.addAttribute("editUser", loggedUser.getKorisnik());
        model.addAttribute("profileRole", kRepo.findRoleById( loggedUser.getKorisnik().getTipId()));
        model.addAttribute("grad", lRepo.findById( loggedUser.getKorisnik().getGradId()));
        model.addAttribute("lokacije", lRepo.findAll());
        return("profile");
    }

    @PostMapping("/profile-update")
    public String postProfileEdit(Model model, @ModelAttribute Korisnik korisnik, @AuthenticationPrincipal KorisnikDetails loggedUser)
    {
        kRepo.update( korisnik);
        System.out.println( korisnik.toString());
        loggedUser.setKorisnik( korisnik);
        return "redirect:/profile";
    }
    @PostMapping("/picture-update")
    public String izmeniSliku(@AuthenticationPrincipal KorisnikDetails loggedUser,@RequestParam("image") MultipartFile file) {
        kRepo.updateSlika(loggedUser.getKorisnik(),file);
        try {
            loggedUser.setKorisnikSlika( Base64.getEncoder().encodeToString(file.getBytes()));
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return "redirect:/profile";
    }
}
