package com.example.SkuciSe.controller;

import com.example.SkuciSe.model.korisnik.Korisnik;
import com.example.SkuciSe.model.korisnik.KorisnikDetails;
import com.example.SkuciSe.repository.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import java.util.ArrayList;
import java.util.List;

@Controller
public class AdminController
{
    @Autowired
    KomentarRepository komRepo;
    @Autowired
    KorisnikRepository kRepo;
    @Autowired
    LokacijaRepository lRepo;
    @Autowired
    OglasRepository oRepo;
    @Autowired
    ZahtevRepository zRepo;
    @Autowired
    LajkRepository lajkRepo;
    @Autowired
    KomentarVlasnikRepository komentarVlasnikRepo;
    @GetMapping("/lista-korisnika")
    public String getListaKorisnika(Model model, @AuthenticationPrincipal KorisnikDetails loggedUser)
    {
        if( !kRepo.findRoleById( loggedUser.getKorisnik().getTipId()).equals( "Administrator"))
        {
            return "redirect:/index";
        }
        List<String> list = new ArrayList<String>();
        for (Korisnik k:kRepo.findAll()) {
            list.add(kRepo.findCity(k.getGradId()));
        }
        model.addAttribute("korisnici", kRepo.findAll());
        model.addAttribute("loggedUser", loggedUser);
        model.addAttribute("gradovi", list);
        return "lista-korisnika";
    }

    @PostMapping ("/delete-user/{id}")
    public String deleteUser(@PathVariable("id") Integer id, @AuthenticationPrincipal KorisnikDetails loggedUser, Model model, RedirectAttributes redirectAttributes)
    {
        komentarVlasnikRepo.deleteKomentarVlasnikByKorisnikId( id);
        komRepo.deleteKomentariByKorisnikId(id);
        zRepo.deleteZahteviByKorisnikId(id);
        lajkRepo.deleteLajkByKorisnikId(id);
        oRepo.deleteOglasi(id);
        kRepo.deleteUser(id);
        redirectAttributes.addFlashAttribute("deleted", true);
        return "redirect:/lista-korisnika";
    }

    @PostMapping ("/accept-user/{id}")
    public String acceptUser(@PathVariable("id") Integer id, @AuthenticationPrincipal KorisnikDetails loggedUser, Model model, RedirectAttributes redirectAttributes){
        kRepo.enableKorisnik(id);
        redirectAttributes.addFlashAttribute("accepted", true);
        return "redirect:/lista-korisnika";
    }
}
