package com.example.SkuciSe.controller;

import com.example.SkuciSe.model.korisnik.KorisnikDetails;
import com.example.SkuciSe.model.zahtev.StanjeZahteva;
import com.example.SkuciSe.model.zahtev.Zahtev;
import com.example.SkuciSe.repository.ZahtevRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;

import java.util.Date;

@Controller
public class ZahtevController {

    @Autowired
    ZahtevRepository zRepo;

    @GetMapping("/profile/moji-zahtevi")
    public String getMojiZahtevi(Model model, @AuthenticationPrincipal KorisnikDetails loggedUser)
    {
        model.addAttribute("loggedUser", loggedUser);
        model.addAttribute("zahtevi", zRepo.findAllByKorisnikId( loggedUser.getKorisnik().getKorisnikId()));
        return "moji-zahtevi";
    }

    @PostMapping("/obradi-zahtev/{id}")
    public String postObradizahtev(Model model, @AuthenticationPrincipal KorisnikDetails loggedUser, @ModelAttribute Zahtev noviZahtev, @ModelAttribute("datumIVreme") String datumIVreme,  @PathVariable("id") int oglasId)
    {
        zRepo.insert( loggedUser.getKorisnik().getKorisnikId(), oglasId, noviZahtev, datumIVreme);
        return "redirect:/lista-oglasa/"+oglasId;
    }
}
