package com.example.SkuciSe.controller;

import com.example.SkuciSe.model.komentar.Lajk;
import com.example.SkuciSe.model.korisnik.KorisnikDetails;
import com.example.SkuciSe.repository.LajkRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;

@Controller
public class LajkController
{
    @Autowired
    LajkRepository lajkRepo;
    @GetMapping("/lajkuj-oglas/{oglasId}")
    public String postLajkujOglas(Model model, @AuthenticationPrincipal KorisnikDetails loggedUser, @PathVariable("oglasId") int oglasId)
    {
        lajkRepo.updateLajk( new Lajk( oglasId, loggedUser.getKorisnik().getKorisnikId()));
        return "redirect:/lista-oglasa/" + oglasId;
    }
}
