package com.example.SkuciSe.repository;

import com.example.SkuciSe.model.oglas.Oglas;
import com.example.SkuciSe.model.slika.Slika;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

@Component
public class SlikeRepository
{
    @Autowired
    DataBase dataBase;

    public List<Slika> findAllById( int oglasId)
    {
        List<Slika> list = new ArrayList<Slika>();
        String sql = "{ call findAllSlikeByOglasId(?)}";
        ResultSet rs = null;
        CallableStatement stmt = null;
        try {
            stmt = dataBase.connection.prepareCall( sql);
            stmt.setInt( 1, oglasId);
            rs = stmt.executeQuery();
            while( rs.next())
            {
                list.add( new Slika( rs.getInt("slikeId"), rs.getInt("oglasid"), rs.getString("slika") ));
            }
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return list;
    }

    public List<Slika> findAllFirstPics( List<Oglas> oglasi)
    {
        List<Slika> list = new ArrayList<Slika>();
        for( Oglas oglas: oglasi)
        {
            CallableStatement stmt = null;
            String sql = "{call findAllOglasFirstPics(?)}";
            ResultSet rs = null;
            try {
                stmt = dataBase.connection.prepareCall( sql);
                stmt.setInt(1, oglas.getOglasId());
                rs = stmt.executeQuery();
                while( rs.next())
                {
                    list.add( new Slika( rs.getInt("slikeid"), rs.getInt("oglasid"), rs.getString("slika")));
                    break;
                }
            } catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        return( list);
    }


}
