package com.example.SkuciSe.repository;

import com.example.SkuciSe.configuration.AktivanZahtevPostoji;
import com.example.SkuciSe.model.zahtev.StanjeZahteva;
import com.example.SkuciSe.model.zahtev.Zahtev;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.sql.ResultSet;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.*;

@Component
public class ZahtevRepository {
    @Autowired
    DataBase dataBase;
    public void insert( int korisnikId, int oglasId, Zahtev noviZahtev, String datumIVreme) throws AktivanZahtevPostoji
    {
        this.postaviFinishedZahteve();
        try {
            CallableStatement provera = dataBase.connection.prepareCall( "{ call daLiPostojiAktivanZahtev(?,?)}");
            provera.setInt( 1, korisnikId);
            provera.setInt( 2, oglasId);
            ResultSet rs = provera.executeQuery();
            while( rs.next()) {
                System.out.println(rs.getString("stanje"));
                throw new AktivanZahtevPostoji();
            }
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }

        String datum = datumIVreme.split(" ")[0];
        LocalDate datumFormatiran = LocalDate.parse(datum, DateTimeFormatter.ofPattern("MM/dd/yyyy"));
        String vreme = datumIVreme.split(" ")[1];
        noviZahtev.setDatum( datumFormatiran.toString());
        noviZahtev.setVreme( vreme);
        noviZahtev.setKorisnikId( korisnikId);
        noviZahtev.setOglasId( oglasId);
        noviZahtev.setStatus( StanjeZahteva.CEKANJE);

        String sql="{call insertZahtev(?,?,?,?,?)}";
        CallableStatement stmt=null;
        try {
            stmt=dataBase.connection.prepareCall(sql);
            stmt.setInt(1,noviZahtev.getKorisnikId());
            stmt.setInt(2,noviZahtev.getOglasId());
            stmt.setString(3,noviZahtev.getDatum());
            stmt.setString(4,noviZahtev.getVreme());
            stmt.setString(5,noviZahtev.getStatus().toString());
            stmt.executeUpdate();
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Zahtev> findAllByKorisnikId( int korisnikId)
    {
        this.postaviFinishedZahteve();
        List<Zahtev> list = new ArrayList<Zahtev>();
        String sql = "call findAllZahtevByKorisnikId(?)";
        CallableStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dataBase.connection.prepareCall( sql);
            stmt.setInt( 1, korisnikId);
            rs = stmt.executeQuery();
            while( rs.next())
            {
                Zahtev zahtev =  new Zahtev( rs.getInt(1), rs.getInt(2), rs.getInt(3), rs.getString(4), rs.getString(5), StanjeZahteva.valueOf(rs.getString(6)));
                list.add( zahtev);
            }
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return( list);
    }

    public List<Zahtev> findAllByOglasId( int oglasId)
    {
        this.postaviFinishedZahteve();
        List<Zahtev> list = new ArrayList<Zahtev>();
        String sql = "call findAllZahtevByOglasId(?)";
        CallableStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dataBase.connection.prepareCall( sql);
            stmt.setInt( 1, oglasId);
            rs = stmt.executeQuery();
            while( rs.next())
            {
                Zahtev zahtev =  new Zahtev( rs.getInt(1), rs.getInt(2), rs.getInt(3), rs.getString(4), rs.getString(5), StanjeZahteva.valueOf(rs.getString(6)));
                list.add( zahtev);
            }
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return( list);
    }

    public void deleteZahteviByKorisnikId(Integer id)
    {
        String sql = "{call deleteZahteviByKorisnikId(?)}";
        CallableStatement cs = null;
        try {
            cs = dataBase.connection.prepareCall(sql);
            cs.setInt(1, id);
            cs.execute();
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void updateZahtevStatus(int zahtevId, StanjeZahteva potvrdjen)
    {
        String sql = "{ call updateZahtevStatus(?,?)}";
        CallableStatement cs = null;
        try {
            cs = dataBase.connection.prepareCall(sql);
            cs.setInt(1, zahtevId);
            cs.setString(2, potvrdjen.toString());
            cs.execute();
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
        this.postaviFinishedZahteve();
    }

    public void postaviFinishedZahteve()
    {
        String sql = "{ call postaviFinishedZahteve()}";
        CallableStatement cs = null;
        try {
            cs = dataBase.connection.prepareCall(sql);
            cs.execute();
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteZahtev(int zahtevId)
    {
        String sql = "{ call deleteZahtev(?)}";
        CallableStatement cs = null;
        try {
            cs = dataBase.connection.prepareCall(sql);
            cs.setInt( 1, zahtevId);
            cs.execute();
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}
