package com.example.SkuciSe.controller;

import com.example.SkuciSe.model.korisnik.Korisnik;
import com.example.SkuciSe.model.korisnik.KorisnikDetails;
import com.example.SkuciSe.model.oglas.Oglas;
import com.example.SkuciSe.repository.KorisnikRepository;
import com.example.SkuciSe.repository.LokacijaRepository;
import com.example.SkuciSe.repository.OglasRepository;
import com.example.SkuciSe.repository.SlikeRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.List;

@Controller
public class OglasController
{
    @Autowired
    LokacijaRepository lRepo;

    @Autowired
    KorisnikRepository kRepo;

    @Autowired
    OglasRepository oRepo;

    @Autowired
    SlikeRepository sRepo;

    @GetMapping("/novi-oglas")
    public String getNoviOglas(Model model, @AuthenticationPrincipal KorisnikDetails loggedUser)
    {
        model.addAttribute("loggedUser", loggedUser);
        model.addAttribute("newOglas", new Oglas());
        model.addAttribute("lokacije", lRepo.findAll());
        return("novi-oglas-form");
    }

    @PostMapping("/novi-oglas/save")
    public String postSaveNoviOglas( @ModelAttribute("newOglas") Oglas newOglas,  @RequestParam("images") MultipartFile[] files, @AuthenticationPrincipal KorisnikDetails loggedUser)
    {
        oRepo.insert( loggedUser.getKorisnik().getKorisnikId(), newOglas, files);
        return("redirect:/profile");
    }

    @GetMapping("/lista-oglasa")
    public String getListaOglasa( Model model,
                                  @AuthenticationPrincipal KorisnikDetails loggedUser,
                                  @RequestParam(value = "vrstaOglasaId", required=false) Integer vrstaOglasaId,
                                  @RequestParam(value = "lokacijaId", required=false) Integer lokacijaId,
                                  @RequestParam(value = "cenaMin", required=false) Double cenaMin,
                                  @RequestParam(value = "cenaMax", required=false) Double cenaMax,
                                  @RequestParam(value = "brojSoba", required=false) Integer brojSoba,
                                  @RequestParam(value = "kvadraturaMin", required=false) Double kvadraturaMin,
                                  @RequestParam(value = "kvadraturaMax", required=false) Double kvadraturaMax,
                                  @RequestParam(value = "lift", required=false) Boolean lift,
                                  @RequestParam(value = "grejanje", required=false) Boolean grejanje,
                                  @RequestParam(value = "namesten", required=false) Boolean namesten)
    {
        model.addAttribute("loggedUser", loggedUser);
        List<Oglas> listaOglasa = oRepo.findAll( vrstaOglasaId, lokacijaId, brojSoba, cenaMin, cenaMax, kvadraturaMin,kvadraturaMax, lift, grejanje, namesten);
        while(listaOglasa.size() % 3 != 0){
            Oglas o = new Oglas();
            listaOglasa.add(o);
        }
        model.addAttribute("oglasi",listaOglasa);
        List<String> list = new ArrayList<String>();
        for (Oglas o:oRepo.findAll()) {
            list.add(kRepo.findCity(o.getLokacijaId()));
        }
        model.addAttribute("gradovi",list);
        return "/lista-oglasa";
    }

    @GetMapping("/lista-oglasa/{oglasId}")
    public String getOglas(Model model, @PathVariable("oglasId") int oglasId, @AuthenticationPrincipal KorisnikDetails loggedUser)
    {
        model.addAttribute("loggedUser", loggedUser);
        model.addAttribute("oglas", oRepo.findById( oglasId));
        model.addAttribute("slike", sRepo.findAllById( oglasId));
        return("oglas");
    }
    @GetMapping("/profile/moji-oglasi")
    public String getMojiOglasa( Model model,
                                 @AuthenticationPrincipal KorisnikDetails loggedUser,
                                 @RequestParam(value = "vrstaOglasaId", required=false) Integer vrstaOglasaId,
                                 @RequestParam(value = "lokacijaId", required=false) Integer lokacijaId,
                                 @RequestParam(value = "cenaMin", required=false) Double cenaMin,
                                 @RequestParam(value = "cenaMax", required=false) Double cenaMax,
                                 @RequestParam(value = "brojSoba", required=false) Integer brojSoba,
                                 @RequestParam(value = "kvadraturaMin", required=false) Double kvadraturaMin,
                                 @RequestParam(value = "kvadraturaMax", required=false) Double kvadraturaMax,
                                 @RequestParam(value = "lift", required=false) Boolean lift,
                                 @RequestParam(value = "grejanje", required=false) Boolean grejanje,
                                 @RequestParam(value = "namesten", required=false) Boolean namesten)
    {
        model.addAttribute("loggedUser", loggedUser);
        List<Oglas> listaOglasa = oRepo.findAllByKorisnikId( loggedUser.getKorisnik().getKorisnikId(), vrstaOglasaId, lokacijaId, brojSoba, cenaMin, cenaMax, kvadraturaMin,kvadraturaMax, lift, grejanje, namesten);
        while(listaOglasa.size() % 3 != 0){
            Oglas o = new Oglas();
            listaOglasa.add(o);
        }
        model.addAttribute("oglasi",listaOglasa);
        List<String> list = new ArrayList<String>();
        for (Oglas o:listaOglasa) {
            list.add(kRepo.findCity(o.getLokacijaId()));
        }
        model.addAttribute("gradovi",list);
        return "/lista-oglasa";
    }
}
