package com.example.SkuciSe.repository;

import com.example.SkuciSe.model.korisnik.Korisnik;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.sql.*;
import java.util.Base64;
import java.util.Optional;

@Component
public class KorisnikRepository
{
    Connection connection = null;
    Statement statement = null;
    public KorisnikRepository()
    {
        try {
            connection = DriverManager.getConnection("jdbc:mariadb://localhost/skucise","root","");
            statement = connection.createStatement();
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void insert( Korisnik korisnik, MultipartFile multipartFile) throws IOException
    {
        String slika = Base64.getEncoder().encodeToString(multipartFile.getBytes());
        System.out.println( slika);
        String sql = "insert into korisnik( ime, prezime, telefon, email, sifra, tipId, slika) values('"+korisnik.getIme()+"','"+korisnik.getPrezime()+"','"+korisnik.getTelefon()+"','"+korisnik.getEmail()+"','"+new BCryptPasswordEncoder().encode(korisnik.getSifra())+"',1, '"+ slika +"')";
        System.out.println( sql);
        try {
            statement.executeUpdate( sql);
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void update( Korisnik korisnik)
    {
        String sql = " update korisnik " +
                     " set ime = '" + korisnik.getIme() +
                     "',prezime = '" + korisnik.getPrezime() +
                     "',email = '" + korisnik.getEmail() +
                     "',sifra = '" + new BCryptPasswordEncoder().encode(korisnik.getSifra()) +
                     "',telefon = '" + korisnik.getTelefon() +
                     "' where korisnikid = " + korisnik.getKorisnikId();
        try {
            System.out.println( sql);
            statement.executeUpdate( sql);
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void updateSlika( Korisnik korisnik, MultipartFile file)
    {
        String fileName = StringUtils.cleanPath(file.getOriginalFilename());
        String slika = null;
        String sql = null;
        try {
             slika = Base64.getEncoder().encodeToString(file.getBytes());
             sql = " insert into korisnik " +
                    " set slika = '" + slika + "' where korisnikid = " + korisnik.getKorisnikId();
            System.out.println( sql);
            statement.executeUpdate( sql);
        } catch (SQLException e) {
            throw new RuntimeException(e);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Korisnik findByEmail(String email)
    {
        String sql = "select * from korisnik where email = '"+email+"'";
        ResultSet rs = null;
        try {
            rs = statement.executeQuery( sql);
            while( rs.next())
            {
                return ( new Korisnik( rs.getInt("korisnikId"), rs.getString("ime"), rs.getString("prezime"), rs.getString("email"), rs.getString("sifra"), rs.getString("telefon"), rs.getInt("tipid"), rs.getString("slika")));
            }
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return( null);
    }
    public Korisnik findById(Integer id){
        String sql = "select * from korisnik where KorisnikId = "+id;
        ResultSet rs = null;
        try {
            rs = statement.executeQuery( sql);
            while( rs.next())
            {
                return ( new Korisnik( rs.getInt("korisnikId"), rs.getString("ime"), rs.getString("prezime"), rs.getString("email"), rs.getString("sifra"), rs.getString("telefon"), rs.getInt("tipid"), rs.getString("slika")));
            }
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return( null);
    }

    public String findRoleById( int tipid)
    {
        String sql = "select * from tipkorisnika where tipId = "+tipid;
        ResultSet rs = null;
        try {
            rs = statement.executeQuery( sql);
            while( rs.next())
            {
                return rs.getString("naziv");
            }
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return( null);
    }
}
