package com.example.SkuciSe.repository;

import com.example.SkuciSe.model.zahtev.StanjeZahteva;
import com.example.SkuciSe.model.zahtev.Zahtev;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.sql.ResultSet;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.*;

@Component
public class ZahtevRepository {
    @Autowired
    DataBase dataBase;
    public void insert(Zahtev noviZahtev, String datumIVreme)
    {
        String datum = datumIVreme.split("T")[0];
        String vreme = datumIVreme.split("T")[1];
        noviZahtev.setDatum( datum);
        noviZahtev.setVreme( vreme);
        System.out.println( noviZahtev.toString());

        String sql="{call insertZahtev(?,?,?,?,?)}";
        CallableStatement stmt=null;
        try {
            stmt=dataBase.connection.prepareCall(sql);
            stmt.setInt(1,noviZahtev.getKorisnikId());
            stmt.setInt(2,noviZahtev.getOglasId());
            stmt.setString(3,noviZahtev.getDatum());
            stmt.setString(4,noviZahtev.getVreme());
            stmt.setString(5,noviZahtev.getStatus().toString());
            stmt.executeUpdate();
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Zahtev> findAllByKorisnikId( int korisnikId)
    {
        List<Zahtev> list = new ArrayList<Zahtev>();
        String sql = "call findAllZahtevByKorisnikId(?)";
        CallableStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dataBase.connection.prepareCall( sql);
            stmt.setInt( 1, korisnikId);
            rs = stmt.executeQuery();
            while( rs.next())
            {
                Zahtev zahtev =  new Zahtev( rs.getInt(1), rs.getInt(2), rs.getInt(3), rs.getString(4), rs.getString(5), StanjeZahteva.valueOf(rs.getString(6)));
                System.out.println( zahtev.toString());
                list.add( zahtev);
            }
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return( list);
    }

    public List<Zahtev> findAllByOglasId( int oglasId)
    {
        List<Zahtev> list = new ArrayList<Zahtev>();
        String sql = "call findAllZahtevByOglasId(?)";
        CallableStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dataBase.connection.prepareCall( sql);
            stmt.setInt( 1, oglasId);
            rs = stmt.executeQuery();
            while( rs.next())
            {
                Zahtev zahtev =  new Zahtev( rs.getInt(1), rs.getInt(2), rs.getInt(3), rs.getString(4), rs.getString(5), StanjeZahteva.valueOf(rs.getString(6)));
                System.out.println( zahtev.toString());
                list.add( zahtev);
            }
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return( list);
    }
}
