package com.example.SkuciSe.controller;

import com.example.SkuciSe.model.korisnik.Korisnik;
import com.example.SkuciSe.model.korisnik.KorisnikDetails;
import com.example.SkuciSe.repository.KorisnikRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class AppController
{
    @Autowired
    KorisnikRepository kRepo;

    @GetMapping({"/","","/index"})
    public String getIndex(Model model, @AuthenticationPrincipal KorisnikDetails korisnik)
    {
        model.addAttribute("loggedUser", korisnik);
        return("index");
    }

    @GetMapping("/login")
    public String getLogin( Model model, @AuthenticationPrincipal KorisnikDetails loggedUser)
    {
        if( loggedUser != null )
            return "redirect:/index";
        return("login");
    }

    @GetMapping("/register")
    public String getRegister( Model model, @AuthenticationPrincipal KorisnikDetails loggedUser)
    {
        if( loggedUser != null )
            return "redirect:/index";
        model.addAttribute("newUser", new Korisnik());
        return("register");
    }

    @PostMapping("/register-proccess")
    public String postRegisterProccess(@ModelAttribute Korisnik korisnik, @RequestParam("image") MultipartFile multipartFile)
    {
        System.out.println(korisnik);
        kRepo.insert( korisnik, multipartFile);
        return("redirect:/login");
    }

    @GetMapping("/profile/{korisnikid}")
    public String getProfile(@PathVariable("korisnikid") int korisnikid, Model model, @AuthenticationPrincipal KorisnikDetails korisnik)
    {
        model.addAttribute("korisnik", kRepo.findById(korisnikid));
        model.addAttribute("loggedUser", korisnik);
        return("profile");
    }
}
