(function () {
    'use strict'
    const forms = document.querySelectorAll('.requires-validation')
    Array.from(forms)
        .forEach(function (form) {
            form.addEventListener('submit', function (event) {
                if (!form.checkValidity()) {
                    event.preventDefault()
                    event.stopPropagation()
                }

                form.classList.add('was-validated')
            }, false)
        })
})()

window.onload = proveraLogin();
window.onload = postaviFiltere();

function proveraLogin() {
    const queryString = window.location.search;
    if (queryString === "?error") {
        document.getElementById("losaSifra").style.display = "block";
    } else {
        if (document.getElementById("losaSifra") != null)
            document.getElementById("losaSifra").style.display = "none";
    }
}

function validateForm() {
    var prva = document.getElementById("prvaSifra").value;
    var druga = document.getElementById("drugaSifra").value;
    var errorCode1 = document.getElementById("errorCode1");
    var errorCode2 = document.getElementById("errorCode2");

    if (prva.trim().length === 0 || druga.trim().length === 0) {
        errorCode1.style.display = "block";
        return false;
    } else if (prva != druga) {
        errorCode1.style.display = "none";
        errorCode2.style.display = "block";
        return false;
    } else
        return true;
}

document.getElementById("flexRadioDefault1").setAttribute("checked", "checked")

function postaviFiltere() {
    const params = new URLSearchParams(window.location.search)
    let pretraga = document.getElementById("pretraga")
    let cenaMin = document.getElementById("cena-min")
    let cenaMax = document.getElementById("cena-max")
    let radioIzdavanje = document.getElementById("radio-izdavanje")
    let radioProdaja = document.getElementById("radio-prodaja")
    let lokacijeOpt = document.getElementById("lokacijeopt")
    let kvadraturaMin = document.getElementById("kvadratura-min")
    let kvadraturaMax = document.getElementById("kvadratura-max")
    let brojSoba = document.getElementById("broj-soba")
    let lift = document.getElementById("check-lift")
    let grejanje = document.getElementById("check-grejanje")
    let namesten = document.getElementById("check-namesten")
    for (const param of params) {
        console.log(param[0], param[1])
        if (param[0] === "pretraga" && param[1] !== "") {
            pretraga.value = param[1];
        }
        if (param[0] === "cenaMin" && param[1] !== "") {
            cenaMin.value = param[1];
        }
        if (param[0] === "cenaMax" && param[1] !== "") {
            cenaMax.value = param[1];
        }
        if (param[0] === "vrstaOglasaId" && param[1] !== "") {
            if (param[1] === "2")
                radioIzdavanje.setAttribute("checked", "checked")
            else
                radioProdaja.setAttribute("checked", "checked")
        }
        if (param[0] === "lokacijaId" && param[1] !== "0") {
            lokacijeOpt.value = param[1];
        }
        if (param[0] === "kvadraturaMin" && param[1] !== "") {
            kvadraturaMin.value = param[1];
        }
        if (param[0] === "kvadraturaMax" && param[1] !== "") {
            kvadraturaMax.value = param[1];
        }
        if (param[0] === "brojSoba" && param[1] !== "") {
            brojSoba.value = param[1];
        }
        if (param[0] === "lift" && param[1] !== "") {
            lift.checked = true;
        }
        if (param[0] === "grejanje" && param[1] !== "") {
            grejanje.checked = true;
        }
        if (param[0] === "namesten" && param[1] !== "") {
            namesten.checked = true;
        }
    }
}
function promenaProdaja(radio){
    if(radio.value === "2"){
        document.getElementById("prodajaLabel").innerText = "Kirija";
    }
    else
        document.getElementById("prodajaLabel").innerText = "Cena po m2";
}
$(document).ready(function() {
    $('#rateMe1').mdbRate();
});

function prikaziOglase(){
    document.getElementById("div-oglasi").style.display = "block";
    document.getElementById("div-ocene").style.display = "none";
}

function prikaziOcene(){
    document.getElementById("div-oglasi").style.display = "none";
    document.getElementById("div-ocene").style.display = "block";
}
function proveriBroj(){
    const re = new RegExp('^[\+]?[(]?[0-9]{3}[)]?[-\s\.]?[0-9]{3}[-\s\.]?[0-9]{4,6}$');
    let val = document.getElementById("brojTelefona").value;
    if(re.test(val)) {
        return true
    }
    else {
        document.getElementById("brojTelefona").classList.add("slikaPozadina");
        document.getElementById("brojFonaProvera").style.display = "block";
        return false
    }
}