var stompClient = null;

var email = new URLSearchParams( window.location.search).get("email");
console.log( "To: " + email);

$(document).ready(function() {
    console.log("Index page is ready");
    connect();
    $("#send-private").click(function() {
        sendPrivateMessage();
    });
});

function connect() {
    var socket = new SockJS('out-websocket');
    stompClient = Stomp.over(socket);
    stompClient.connect({}, function (frame) {
        console.log('Connected: ' + frame);
        stompClient.subscribe('/user/topic/private-messages', function (message) {
            showMessage(JSON.parse(message.body).content);
        });
    });
}

function showMessage(message) {
    $("#messages").append("<tr><td>" +message+"</td></tr>");
}

function sendPrivateMessage() {
    console.log("sending private message");
    stompClient.send("/ws/private-message", {}, JSON.stringify({ 'from':"", 'to':email/*$("#to").val()*/, 'messageContent': $("#private-message").val()}));
    $("#private-message").val("");
}