-- phpMyAdmin SQL Dump
-- version 5.2.0
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Generation Time: Sep 21, 2022 at 11:15 PM
-- Server version: 10.4.24-MariaDB
-- PHP Version: 8.1.6

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `skucise`
--

DELIMITER $$
--
-- Procedures
--
CREATE DEFINER=`root`@`localhost` PROCEDURE `averageOcenaByKorisnikId` (IN `kid` INT)   Begin
    select avg(ocena)
    from KomentarVlasnik
    where korisnikid = kid;
End$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `averageOcenaByOglasId` (IN `oid` INT)   BEGIN
    SELECT AVG(ocena)
    FROM komentar
    WHERE oglasId=oid; 
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `countLajks` (IN `oid` INT)   BEGIN
  select count(*) from lajk where oglasid = oid;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `countOglasByKorisnikId` (IN `kid` INT)   Begin
    select COUNT(*)
    from oglas
    where korisnikid = kid;
End$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `daLiPostojiAktivanZahtev` (IN `kid` INT, IN `oid` INT)   BEGIN
select * from zahtev 
where korisnikid = kid and 
	  oglasid = oid and ( stanje = 'CEKANJE' or 
                          stanje = 'POTVRDJEN');
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `deleteKomentarByKorisnikId` (IN `kid` INT)   BEGIN
    delete from komentar where KorisnikId = kid;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `deleteKomentarByOglasId` (IN `oid` INT)   BEGIN
    delete from komentar where OglasId = oid;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `deleteKomentarVlasnikByKorisnikId` (IN `kid` INT)   BEGIN
	delete from komentarvlasnik
    WHERE vlasnikid = kid or korisnikid = kid;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `deleteKorisnik` (IN `id` INT)   BEGIN
    delete from korisnik where KorisnikId = id;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `deleteLajk` (IN `oid` INT, IN `kid` INT)   BEGIN
    delete from lajk where oglasId = oid and korisnikid = kid;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `deleteLajkByKorisnikId` (IN `kid` INT)   BEGIN
    delete from lajk where KorisnikId = kid;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `deleteLajkByOglasId` (IN `oid` INT)   BEGIN
    delete from lajk where oglasId = oid;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `deleteOglas` (IN `oid` INT)   BEGIN
	delete from lajk
    where oglasid = oid;
    
    delete from zahtev
    WHERE oglasid = oid;
    
    delete from komentar
    WHERE oglasid = oid;
    
    delete from slike
    WHERE oglasid = oid;
    
    delete from oglas
    WHERE oglasid = oid;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `deleteOglasiByKorisnikId` (IN `kid` INT)   BEGIN
	delete from oglas where KorisnikId = kid;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `deleteSlike` (IN `id` INT)   BEGIN
	delete from slike where oglasid = id;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `deleteZahtev` (IN `zid` INT)   BEGIN
	delete from zahtev
    where zahtevid = zid;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `deleteZahteviByKorisnikId` (IN `kid` INT)   BEGIN
	delete from zahtev
    where korisnikid = kid;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `deleteZahteviByOglasId` (IN `oid` INT)   BEGIN
	delete from zahtev 
    where oglasid = oid;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `enableKorisnik` (IN `id` INT)   BEGIN
    update korisnik set enabled = true where korisnikid = id;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `findAll` ()   BEGIN
	select * from oglas;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `findAllByKorisnikId` (IN `id` INT)   BEGIN
    select * from oglas where korisnikid = id;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `findAllKomentarByOglasID` (IN `oid` INT)   BEGIN
    select * from komentar where oglasid = oid;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `findAllKomentarVlasnikByKorisnikID` (IN `kid` INT)   BEGIN
	select * from komentarvlasnik
    where korisnikid = kid;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `findAllKorisnik` ()   BEGIN
	select * from korisnik where TipID = 1;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `findAllLokacija` ()   BEGIN
	select * from lokacija;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `findAllOglasFirstPics` (IN `oid` INT)   BEGIN
	select * from slike where oglasid = oid;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `findAllSlikeByOglasId` (IN `id` INT)   BEGIN
	select * from slike where oglasid = id;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `findAllZahtevByKorisnikId` (IN `korisnik` INT)   BEGIN
    select * from zahtev where KorisnikID = korisnik;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `findAllZahtevByOglasId` (IN `oglas` INT)   BEGIN
    select * from zahtev where OglasID = oglas and stanje <> 'ODBIJEN';
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `findByEmail` (IN `e` VARCHAR(64))   BEGIN
select * from korisnik where email = e;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `findCityById` (IN `id` INT)   BEGIN
    select Naziv from lokacija where LokacijaID = id;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `findKorisnikById` (IN `korId` INT)   BEGIN
    select * from korisnik where KorisnikId = korId;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `findLokacijaById` (IN `lid` INT)   BEGIN
	select * from lokacija where lokacijaid = lid;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `findOglasbyId` (IN `oid` INT)   BEGIN
	select * from oglas where oglasid = oid;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `findRoleById` (IN `tId` INT)   BEGIN
    select * from tipkorisnika where tipId = tId;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `findZahtevById` (IN `zid` INT)   BEGIN
    select * from zahtev where ZahtevID = zid;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `insertKomentar` (IN `korisnikId` INT, IN `oglasId` INT, IN `kom` VARCHAR(256), IN `oce` INT)   BEGIN
    insert into komentar(korisnikID, oglasId, Komentar, Ocena, datum, vreme)
    values(korisnikId, oglasId, kom,oce, curdate(), curtime());
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `insertKomentarVlasnik` (IN `vid` INT, IN `kid` INT, IN `o` INT, IN `k` TEXT)   BEGIN
	insert into komentarvlasnik( vlasnikid, korisnikid, ocena ,komentar, datum, vreme)
    VALUES( vid, kid, o, k, curdate(), curtime());
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `insertKorisnik` (IN `ime` VARCHAR(64), IN `prezime` VARCHAR(64), IN `telefon` VARCHAR(64), IN `email` VARCHAR(64), IN `sifra` VARCHAR(256), IN `tipid` INT, IN `slika` LONGTEXT, IN `gradId` INT)   BEGIN
	insert into korisnik( ime, prezime, telefon, email, sifra, tipId, slika, gradid, enabled)
    values(ime, prezime, telefon, email, sifra, tipid, slika, gradId, false);
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `insertLajk` (IN `korId` INT, IN `oglId` INT)   BEGIN
    insert into lajk(korisnikId, oglasId)
    values(korId, oglId);
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `insertOglas` (IN `korisnikId` INT, IN `naslov` VARCHAR(64), IN `opis` VARCHAR(1000), IN `lokacijaId` INT, IN `cena` DOUBLE, IN `vrstaOglasaId` INT, IN `kvadratura` DOUBLE, IN `brojSoba` INT, IN `namesten` BOOLEAN, IN `grejanje` BOOLEAN, IN `lift` BOOLEAN, IN `lokacija` VARCHAR(64))   BEGIN
	insert into oglas( korisnikID, naslov, opis, lokacijaId, cena, vrstaoglasaid, kvadratura, brojsoba, namesten, grejanje, lift, lokacija)
	values( korisnikId, naslov, opis, lokacijaId, cena, vrstaOglasaId, kvadratura, brojSoba, namesten, grejanje, lift, lokacija);
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `insertSlika` (IN `oglasID` INT, IN `slika` LONGTEXT)   BEGIN
    insert into slike(oglasId,slika) values(oglasID,slika);
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `insertZahtev` (IN `korisnikId1` INT, IN `oglasId1` INT, IN `datum1` DATE, IN `vreme1` TIME, IN `stanje1` VARCHAR(32))   BEGIN
    insert into zahtev(korisnikID, oglasId, datum, vreme, stanje, korisnikKom, vlasnikKom)
    values(korisnikId1, oglasId1, datum1, vreme1, stanje1, false, false);
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `isLiked` (IN `oid` INT, IN `kid` INT)   BEGIN
  select count(*) from lajk where oglasid = oid and korisnikid = kid;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `postaviFinishedZahteve` ()   BEGIN
	update zahtev
    set stanje = 'ZAVRSEN'
    where concat(datum,' ',vreme) < concat(curdate(),' ',curtime()) and stanje = 'POTVRDJEN';
    
    delete from zahtev
    where concat(datum,' ',vreme) < concat(curdate(),' ',curtime()) and stanje = 'CEKANJE';
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `updateKorisnik` (IN `ime` VARCHAR(64), IN `prezime` VARCHAR(64), IN `email` VARCHAR(64), IN `telefon` VARCHAR(64), IN `gradId` INT, IN `korId` INT)   BEGIN
update korisnik set ime = ime,
	prezime = prezime,
	email = email,
	telefon = telefon,
    gradId = gradId
where korisnikId = korId;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `updateSifraKorisnika` (IN `sifra` VARCHAR(256), IN `id` INT)   BEGIN
    update korisnik set sifra = sifra where korisnikid = id;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `updateSlika` (IN `slika` LONGTEXT, IN `korId` INT)   BEGIN
    update korisnik set slika = slika where korisnikid = korId;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `updateZahtevStatus` (IN `zid` INT, IN `novoStanje` VARCHAR(32))   BEGIN
	UPDATE zahtev
    SET stanje = novoStanje
    WHERE zahtevid = zid;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `zahtevKorisnikKom` (IN `zid` INT)   BEGIN
    UPDATE zahtev
    SET korisnikKom = true
    WHERE ZahtevID=zid;  
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `zahtevVlasnikKom` (IN `zid` INT)   BEGIN
    UPDATE zahtev
    SET vlasnikKom = true
    WHERE ZahtevID=zid;  
END$$

DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `komentar`
--

CREATE TABLE `komentar` (
  `KomentarId` int(11) NOT NULL,
  `KorisnikId` int(11) NOT NULL,
  `OglasId` int(11) NOT NULL,
  `Komentar` longtext DEFAULT NULL,
  `Ocena` int(11) DEFAULT NULL,
  `datum` date DEFAULT NULL,
  `vreme` time DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `komentarvlasnik`
--

CREATE TABLE `komentarvlasnik` (
  `komentarVlasnikId` int(11) NOT NULL,
  `vlasnikId` int(11) NOT NULL,
  `korisnikId` int(11) NOT NULL,
  `ocena` int(11) DEFAULT NULL,
  `komentar` text DEFAULT NULL,
  `datum` date DEFAULT NULL,
  `vreme` time DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `korisnik`
--

CREATE TABLE `korisnik` (
  `KorisnikId` int(11) NOT NULL,
  `Ime` varchar(64) DEFAULT NULL,
  `Prezime` varchar(64) DEFAULT NULL,
  `Email` varchar(64) DEFAULT NULL,
  `Sifra` varchar(256) DEFAULT NULL,
  `Telefon` varchar(64) DEFAULT NULL,
  `TipID` int(11) DEFAULT NULL,
  `Slika` longtext DEFAULT NULL,
  `gradid` int(11) DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `korisnik`
--

INSERT INTO `korisnik` (`KorisnikId`, `Ime`, `Prezime`, `Email`, `Sifra`, `Telefon`, `TipID`, `Slika`, `gradid`, `enabled`) VALUES
(62, 'admin', 'admin', 'admin@admin', '$2a$10$eD13.Hb65DT/P9g7bTjRF.ypb2i2o.hFOPIi8E1oTOs0VSqaN0UFq', '123', 2, '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', 4, 1),
(65, 'Pera', 'Peric', 'pera.peric@gmail.com', '$2a$10$8hKZQGvguz/lOOe6UDKMO.7zF9hQGzAFDHMIx.u.eK1Of0JTfgJcG', '0695123883', 1, '/9j/4AAQSkZJRgABAQAAAQABAAD/2wCEAAkGBxAPEBAPEBAQDxAPEBUVDxAPDxUVEA8VFRYWGBUVGBUYHiggGBolHRUWITEhJSkrLi4uFx8zODMsNygtLisBCgoKDg0OGhAQGi0fHR0uLS0tLSstKystLS0tKy0rLSstLSstLS0tLS0rLSstLS0tLTctLS0rLS0tLS0tLSsrLf/AABEIALcBEwMBIgACEQEDEQH/xAAbAAACAgMBAAAAAAAAAAAAAAAAAQQFAgMGB//EADoQAAIBAgQDBgMGBQUBAQAAAAABAgMRBBIhMQVBUQYiYXGBkRMysQdCocHR8BQjUmLhM0Nyc7LCFf/EABkBAQEBAQEBAAAAAAAAAAAAAAABAgMEBf/EACURAQEAAgEFAAEEAwAAAAAAAAABAhEDBBIhMUEiE3GR8DJRYf/aAAwDAQACEQMRAD8A9LHcAMugAAAYIEhgAMACBDuIAh3C4gYBcLmJhWrRhFylJRXWTsgum24XOE7S/aBRoKUMPJ1auqUpQtSi9uavL008TzviHarGV5JzxNWOV3ioVJRjGzTjoud1u/poWY2pbI9/uO54JDtjxGMUljK+WDb1ySl6tptr9ToeG/aPiU7zqU8TCyTj8JU5Ky1atrd6+HRci3GwlletXHco+zXajDcQi/hStUirzpS+eK6r+peK9bF2iDIBDAaGAAADAAC4AAXC4AABcAABDABoQ0ICOAARoGSEMAAACAAAIYhiABSGJhULFVZ0oueaM0uU+69NX3lpZJPdctWePdpe0NXEVJVFVlFa5YKs3CCejSUfm0drvR8i4+0jtIsRfD0JP4NNuNSonpVno3FW3jGyfi/JHnlFxb6Wdrtm8cWcsteGVa8t3eV9bmuUbraxvqUru65c1tbxQ1hpPT5WldX99+hvbGioWd1/UrP3Rr+Ck31itk/qSoYeN1Fu0muWsX1WmzLN4GEqanGUG1OKqO/es21FteDa15qSM92mphto4JOeHqUa9JuNSnJyb5NLdeVnl8me7UOLUpqLTlaVrNQk4ptXtmStc8kxGAjSpSUXmlOnHLa2iTvO/o4kCnxKVGN1VqQd7Xp93N7NXVmubMb269sx9vd6dRSSlFqSezTun6maPLexXbiX8THD4qbarNRhVmkrzfyuTWmu13rqrtnqSKwyABkAAAAAMAEAwAQDCwCAdgAaENABFABkaNAABAMACAQwABDEApM5vt1xV4bCTcZKMprKne0nmdrR8bX15W6tFlxri9PCRU6t1CV1Frdz5RV9LvXdpaHjnbTjTxVdTU80IJxppfJZa6dfPnb0Vk2vqbV6mnGNN/KnN8rqU4tJ+6WhVYDDucjbTk75uWu/P9uxacHw1kpdWayvbKvHh+pnFnwvgmfuuSSfhr6MsqfYum7fzJL6Ejhys728EdHRjseDPmz37fWx6bj16UGB7DUk/wCZPMn0VnoW67I4ZXy5lfZN7ap/ki4i1p4Emm0Z/Vyv0/Swx9RzOI7Lxy5VPVbX6WS9ThuLcPqYeooytJQlKcW787J+mx69Ujc4ztvg80bq997cmv39DfFy2ZarnzcOOWHj289xmDrWVWfehJ9b2X5HuPYPizxeBoVJyzVIxyVXzco6Zn4tWfqeR8JxKV6eZp30v8t+Ss9+mx3fYDFqliquFy5FOClBJd1ZEvbRv2R7Lk+b2a8vRBoQwyBggAAAAAAAAAAAAYAA0AIAIo0IaI0YAMIAAAgAAKATMhEooO2WDhXwsoTUn3ouGSyaleyd3olqzwvER1Td22ub/wAHvPauhOpg8RSjGUnOGigk3JJpyivFpNep4pxehD41X4d/hxb+Hm+bLa6v42exrFbNxBw0b3vstl1k9C+wyypLoik4XG8/CKb/ACX1LOtTcnukubbsY5fN079P+OPc6nh66+/Q6DBpSsuZ5tGU00qeIvPW0IxnrZXbva2xbcC7R1I1FTqu766aHlz4b7j34dRL4r0CNF312J9KkrEKk3KGdO+l7dTkuKdp8XCdoOlTjzcv15HPHDdbzy8O9mrFH2ijHJGbulGVm09r7P3sVXC8dicQszrwbW3w5KSfp+9y0xcJYjDVYSWWUoyXk1qn9BrtrPvFxeL4XSc5SS0ms6aVou9rpPlrmt009bf7ParePlCUrqnTfwle94ySWmjvsuaSs+bKXh+Mz2TT0zJrwdv0Z6t2XwkKeHpuMIxm4JTkl3p25t+O575XzMp9i4GIZXIAMdgMQMrCsAAMQCAYgAAADJACACINCGiNGNCGgyAAZQgGAAIYgEzxv7RsC6GMbUUo1YupGS3ndvNddYtteWU9lPPftap93B1LaqdWKfnGLS94kbwm7p5xwdJzm1/SvqX8sHnSttpfxKrg9L79tGret3cu8LVs1HxOPLbvce7p8Z26qVQwNOLhVakpU08mukbqztrs1o+q3KHEUEq06nWV99bvdnV4qSVO76HMQl8SSstHK1299bGMMrfbvnxYTWp5ej8CrXowT1v9CJxLgFOrKpdSUalruOtvLp6ErhVPLCNradGTnJPS9n0Zwls8uuWMqJQ4JTjGFpTc4O6qPSb0StJ81ZLQnTgrbb7mVC/n5hXe1i5W3zXOYzHxHnfCODSdSdS7yxm1Lxa3t7Hq/BL/AMPRvv8ADVzksBRywqwas6lRyira5ZTcV7qz9TuacFFKK2irex6eLK5ZWvJ1OOOHHJPt3/f5ZAAzu8JgAwhAMAEAAFAhgAhGQgGgBABEMkYmSI0BiGGQMSGUAAAAAAAjjvtNws54alOMbxo1s03bWN4uKfld/ijsjGUU000mno01dNeQrWGXbdvCsDdRa5qV/cm0H3l5nbdt+EUqdCnOjShTUarzqnBRvnS1dvGCRw1F2nG+119ThnHv4s5fMXfFElQab1krJHL0MBKTjGMpRSelpNfTcv8Ai1OcU5NOWicVHn+RC4di6jmlGlbXmk7fiYw8Tw75zvykro8BhLqWHqTqXiozjKnVlSfS3da00Za4ik3CMoNupTWuaWtRefUh4LE1ZPO6NpWs3bR+WpMliZpNuhNW+9HLJe17nO6rprLFP4bjFUp357O+jT5jqvoQ+HNSc5pWuu94u+5MjHM4xX3mkvUxqs2z22UaEG4vL3nODb5yta378DoTRh8FTp/KvK7vlXRG89vHh2x8zqOaclmvUNDBAdHnAwAAAAAQDEFAAAAIYANIAQAQxoQ0RoxiGGTQAgKAAABiGACEMTAg8aw6q4etCWzpyd+jisyfukeQVVZ/Q9lx/wDpVf8Aqn/5Z423mS620OWft6un9VN/jHUUc3JWN+FoSpyTjLR8tPqVKuvctuGTTnFyd9DjZp78Mtxf8MjNuPekrP8AaL5LSzK3Azi20+RYSmktDlfLVa4Qy3S2uWHCaGaWd7Q0Xi/8foVmfW3N8i/4SrUo+Ll9WdOGby8/Hl6jK48fj6ljEB7HzWQAAAMEAAAAAAAAIBgFIbEAGSAEAEIaMTJEaMYhhk0AICgGIYAAAACGasRWjTi5Sdkvd+C8QOI+0rtFUw8YUKMsrnKPxpLfK3bJ4XW5xV7NrxLX7Q8POtTnWSu4SztLpf8AIqKcsyTXNXXqZ5ZrT19P9n7JETbQquDTS2fU000yXRw+Z/5OO476u/CxwvEJXutLl1hcTOatv5Efh3CKT1d34XL2jRjFWSS8jlbPjpu/WrDUrLM9yH2b7RVJY+vgpWlTTbp9YNRi2vLVllUZxnAKU1xys+WjWnKokvykb6e/lXPqZ+E/vx6ugBID1PmGhggAYAAAAAAAAAAAAAIYgGgGgCoIxDI0yQzFGQQDEMqAYkaa+LhDd3fRasCRY11qsYK8pKK6ydivrY2o1paC8ry/HT8CH/CuXfneTe2Zts1MTbPiHaOFNP4cHUfV92P6v2KOpxupXaz2UdWopWS1sn1JOKw93YqqlJpXt96S9pM3MYq1w1CNR5ZJNSVrPmcZieEPCV54Z/LHvUJP71KV8vqtY+h1+Aq2yy/pZYdpuErE0Y1Ya1aF5QtvODV5R/BNeKtzMcuO8XTgz7OSbcPLCNK9jdg6N2b8LVT7r9Cbh6NmeDdfW7YscBTstyxiRML+9CYmvMwmmMkQ+ymEU51sW1/r1v5f/XCOWL8nZv1NXGsVfJhoO1TENxbW9Oml/Mn6LbxaOl4Th1GMIpWUY6Lotkvax6Omw89zy9Xyax7VjJaaGtTfNeq/Q2mNj16fNOMk9v8APsMjYhuLT3XM2xbtfl4k0bbUAlIZlQAAAAAAAAAAACAyQCQBUEaMUNEaZoZiZIJTNWIxMaavJ+S5vyRrxmLVKN3q38sev+CnV5PNLWT/AHY1jNiXUxNSp/ZF7RW782bKVBRV+Y8MlJrquRsxb2it2dNMWtMYZpW5Lc31o8lohxioZV4ixc7alRV4iUY5pPaKbZGhhb4enJrWac2v+bcvzIHHqzlGNKPzV6ij6XOoxEFljCK0ilHwSSKtcxThlduTLzhvGaMJ0cNOpGNWrFunF7yUdvLnvvZ22ZCxdPJFtRU5v5V92/j4eH0OGxfZ3E1qrrTk/iOSedaNNfLa21rK3kamO2csv9O6412cSm61H5ZO84f0t7uPh4cvpFo0dNd/wIuD7W4rDKNPGUVUWyrweW/TMrNX9i+/l4qm62H+aPz03a9/Lr05M8PP01n5R9Hpurn+Of8AKDDff0NmMxsaMJTk9kUWL4uo3cnZrl5PUncH4PVq5cTiIu2+HoS0u91Oa5eCPPx8WWd09nNy48eO639nuFzcpYqsn8WsrUoP/appp6+Ler8kdNwvHUak61KnUjKpQajVit4u1/XdrzTRHxHDpTpShKpK8o2eTupeSRwX/wCDjOHV44jC99Llb5oveMlzR9Pj48da2+Jy8tzy29WlszXTdyi4X2soVko1b4WrzhV0jf8Atns/wZeUpJ6xaaezTTT9iWWe2ZdsqkbpoWG2t0M2KijKtDlll5kiJox0Lq/QeFqZl5FsEgBNa38BoxYoAAIoEMQAAAA0gBAFV5kYGSI0yQ721EVvaDEOFFxXzVO6vXf9+Ik2IeHq/HlKq9ndx/4rb8iThobt9SBhu7KcF9yMY/hf8y0m7RuvE9GnO1pwNa+KnFcoq5Y5b1L9DmuA1W8XW62R1MdE31JURsTLvq3I0cSfypczZHVt+JqS+JUvyjsFjBcHptxnK+aOz6eRMp4eK6vzbf1N9gQ2zUarRTMoUV0RnVHBgRsTgITTTimmtYyV1IpKnC1hf52GqOk4b05O6S/p8Y+B1FjnO02ac6NFf71WMG1vZtJ/U1jaljLg3AqeJrLiNamot2dOknenKS/3rc78k+l99Tp3ZtPov39DbUSjTypZVHSNtklt5aaEaD0Xkc5/xrK2+2bldmWVPS1zGKNgRDr8No1NJU4v0NuCwUKUckIpRWytt5G5GSG6aOTHFCSMiKKsbor8FdTaLJEJwy1U+pYlTXsa6L0fmOs9NDChLS/7XgNDYA2IxWgAARQFwEBkmAkIGkAyQARtkkUXFu/iKcOUGtPF6/mvYANYeyo3D5XxGJ8J/wDzEl46eVNLS6ugA7uKr7MRviq76RX1OpxUtLABL7X6jO9sq57s3YanyQAQSZ6GCAAMaqFTAAN7joU/FKd8VgX1rP8ACLkv/IAIjoKiumRaS0Xr9WMCfBsgja0AEUrGSQgIM0h5QABSutTGrDMlLoIAlZS109jXPRR/umhgVG6SFYAMVuE0FhARo7CsABDSAACv/9k=', 4, 1);

-- --------------------------------------------------------

--
-- Table structure for table `lajk`
--

CREATE TABLE `lajk` (
  `korisnikId` int(11) NOT NULL,
  `oglasId` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `lokacija`
--

CREATE TABLE `lokacija` (
  `LokacijaID` int(11) NOT NULL,
  `Naziv` varchar(64) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `lokacija`
--

INSERT INTO `lokacija` (`LokacijaID`, `Naziv`) VALUES
(1, 'Beograd'),
(2, 'Novi Sad'),
(3, 'Niš'),
(4, 'Kragujevac'),
(5, 'Subotica'),
(6, 'Čačak'),
(7, 'Kraljevo'),
(8, 'Kruševac'),
(9, 'Smederevo'),
(10, 'Leskovac'),
(11, 'Jagodina'),
(12, 'Sombor');

-- --------------------------------------------------------

--
-- Table structure for table `oglas`
--

CREATE TABLE `oglas` (
  `OglasID` int(11) NOT NULL,
  `KorisnikID` int(11) NOT NULL,
  `Naslov` varchar(64) DEFAULT NULL,
  `Opis` varchar(1000) DEFAULT NULL,
  `LokacijaID` int(11) NOT NULL,
  `Cena` double DEFAULT NULL,
  `VrstaOglasaID` int(11) NOT NULL,
  `kvadratura` double DEFAULT NULL,
  `brojSoba` int(11) DEFAULT NULL,
  `namesten` tinyint(1) DEFAULT NULL,
  `grejanje` tinyint(1) DEFAULT NULL,
  `lift` tinyint(1) DEFAULT NULL,
  `lokacija` varchar(64) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `slike`
--

CREATE TABLE `slike` (
  `slikeId` int(11) NOT NULL,
  `oglasId` int(11) DEFAULT NULL,
  `slika` longtext DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `tipkorisnika`
--

CREATE TABLE `tipkorisnika` (
  `TipID` int(11) NOT NULL,
  `Naziv` varchar(64) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `tipkorisnika`
--

INSERT INTO `tipkorisnika` (`TipID`, `Naziv`) VALUES
(1, 'Korisnik'),
(2, 'Administrator');

-- --------------------------------------------------------

--
-- Table structure for table `vrstaoglasa`
--

CREATE TABLE `vrstaoglasa` (
  `VrstaOglasaID` int(11) NOT NULL,
  `Naziv` varchar(64) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `vrstaoglasa`
--

INSERT INTO `vrstaoglasa` (`VrstaOglasaID`, `Naziv`) VALUES
(1, 'prodaja'),
(2, 'izdavanje');

-- --------------------------------------------------------

--
-- Table structure for table `zahtev`
--

CREATE TABLE `zahtev` (
  `ZahtevID` int(11) NOT NULL,
  `KorisnikID` int(11) NOT NULL,
  `OglasID` int(11) NOT NULL,
  `Datum` date DEFAULT NULL,
  `Vreme` time DEFAULT NULL,
  `Stanje` varchar(32) DEFAULT NULL,
  `korisnikKom` tinyint(1) DEFAULT NULL,
  `vlasnikKom` tinyint(1) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Indexes for dumped tables
--

--
-- Indexes for table `komentar`
--
ALTER TABLE `komentar`
  ADD PRIMARY KEY (`KomentarId`),
  ADD KEY `KorisnikId` (`KorisnikId`),
  ADD KEY `OglasId` (`OglasId`);

--
-- Indexes for table `komentarvlasnik`
--
ALTER TABLE `komentarvlasnik`
  ADD PRIMARY KEY (`komentarVlasnikId`),
  ADD KEY `vlasnikId` (`vlasnikId`),
  ADD KEY `korisnikId` (`korisnikId`);

--
-- Indexes for table `korisnik`
--
ALTER TABLE `korisnik`
  ADD PRIMARY KEY (`KorisnikId`),
  ADD KEY `TipID` (`TipID`);

--
-- Indexes for table `lajk`
--
ALTER TABLE `lajk`
  ADD PRIMARY KEY (`korisnikId`,`oglasId`),
  ADD KEY `oglasId` (`oglasId`);

--
-- Indexes for table `lokacija`
--
ALTER TABLE `lokacija`
  ADD PRIMARY KEY (`LokacijaID`);

--
-- Indexes for table `oglas`
--
ALTER TABLE `oglas`
  ADD PRIMARY KEY (`OglasID`),
  ADD KEY `KorisnikID` (`KorisnikID`),
  ADD KEY `LokacijaID` (`LokacijaID`),
  ADD KEY `VrstaOglasaID` (`VrstaOglasaID`);

--
-- Indexes for table `slike`
--
ALTER TABLE `slike`
  ADD PRIMARY KEY (`slikeId`),
  ADD KEY `oglasId` (`oglasId`);

--
-- Indexes for table `tipkorisnika`
--
ALTER TABLE `tipkorisnika`
  ADD PRIMARY KEY (`TipID`);

--
-- Indexes for table `vrstaoglasa`
--
ALTER TABLE `vrstaoglasa`
  ADD PRIMARY KEY (`VrstaOglasaID`);

--
-- Indexes for table `zahtev`
--
ALTER TABLE `zahtev`
  ADD PRIMARY KEY (`ZahtevID`),
  ADD KEY `KorisnikID` (`KorisnikID`),
  ADD KEY `OglasID` (`OglasID`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `komentar`
--
ALTER TABLE `komentar`
  MODIFY `KomentarId` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=13;

--
-- AUTO_INCREMENT for table `komentarvlasnik`
--
ALTER TABLE `komentarvlasnik`
  MODIFY `komentarVlasnikId` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;

--
-- AUTO_INCREMENT for table `korisnik`
--
ALTER TABLE `korisnik`
  MODIFY `KorisnikId` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=67;

--
-- AUTO_INCREMENT for table `lokacija`
--
ALTER TABLE `lokacija`
  MODIFY `LokacijaID` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=13;

--
-- AUTO_INCREMENT for table `oglas`
--
ALTER TABLE `oglas`
  MODIFY `OglasID` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=47;

--
-- AUTO_INCREMENT for table `slike`
--
ALTER TABLE `slike`
  MODIFY `slikeId` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=78;

--
-- AUTO_INCREMENT for table `tipkorisnika`
--
ALTER TABLE `tipkorisnika`
  MODIFY `TipID` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `vrstaoglasa`
--
ALTER TABLE `vrstaoglasa`
  MODIFY `VrstaOglasaID` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `zahtev`
--
ALTER TABLE `zahtev`
  MODIFY `ZahtevID` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=44;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `komentar`
--
ALTER TABLE `komentar`
  ADD CONSTRAINT `komentar_ibfk_1` FOREIGN KEY (`KorisnikId`) REFERENCES `korisnik` (`KorisnikId`),
  ADD CONSTRAINT `komentar_ibfk_2` FOREIGN KEY (`OglasId`) REFERENCES `oglas` (`OglasID`);

--
-- Constraints for table `komentarvlasnik`
--
ALTER TABLE `komentarvlasnik`
  ADD CONSTRAINT `komentarvlasnik_ibfk_1` FOREIGN KEY (`vlasnikId`) REFERENCES `korisnik` (`KorisnikId`),
  ADD CONSTRAINT `komentarvlasnik_ibfk_2` FOREIGN KEY (`korisnikId`) REFERENCES `korisnik` (`KorisnikId`);

--
-- Constraints for table `korisnik`
--
ALTER TABLE `korisnik`
  ADD CONSTRAINT `korisnik_ibfk_1` FOREIGN KEY (`TipID`) REFERENCES `tipkorisnika` (`TipID`);

--
-- Constraints for table `lajk`
--
ALTER TABLE `lajk`
  ADD CONSTRAINT `lajk_ibfk_1` FOREIGN KEY (`korisnikId`) REFERENCES `korisnik` (`KorisnikId`),
  ADD CONSTRAINT `lajk_ibfk_2` FOREIGN KEY (`oglasId`) REFERENCES `oglas` (`OglasID`);

--
-- Constraints for table `oglas`
--
ALTER TABLE `oglas`
  ADD CONSTRAINT `oglas_ibfk_1` FOREIGN KEY (`KorisnikID`) REFERENCES `korisnik` (`KorisnikId`),
  ADD CONSTRAINT `oglas_ibfk_2` FOREIGN KEY (`LokacijaID`) REFERENCES `lokacija` (`LokacijaID`),
  ADD CONSTRAINT `oglas_ibfk_3` FOREIGN KEY (`VrstaOglasaID`) REFERENCES `vrstaoglasa` (`VrstaOglasaID`);

--
-- Constraints for table `slike`
--
ALTER TABLE `slike`
  ADD CONSTRAINT `slike_ibfk_1` FOREIGN KEY (`oglasId`) REFERENCES `oglas` (`OglasID`);

--
-- Constraints for table `zahtev`
--
ALTER TABLE `zahtev`
  ADD CONSTRAINT `zahtev_ibfk_1` FOREIGN KEY (`KorisnikID`) REFERENCES `korisnik` (`KorisnikId`),
  ADD CONSTRAINT `zahtev_ibfk_2` FOREIGN KEY (`OglasID`) REFERENCES `oglas` (`OglasID`);
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
