Ext.define("Evoksi.view.evoksi.Evoksi", {
  extend: "Ext.ux.GMapPanel",
  alias: "widget.evoksi",
  region: "center",
  requires: [
    "Ext.button.Button",
    "Ext.layout.container.Fit",
    "Evoksi.view.evoksi.EvoksiController",
    "Evoksi.view.evoksi.EvoksiModel"
  ],
  cls: "evoksi-view-evoksi",
  layout: "fit",
  controller: "evoksi",
  viewModel: "evoksi",
  center: {
    lat: 44.0128,
    lng: 20.9114
  },
  mapOptions: {
    mapTypeId: google.maps.MapTypeId.TERRAIN,
    zoom: 15
  },
  dockedItems: [
    {
      xtype: "toolbar",
      dock: "top",
      items: [
        {
          xtype: "button",
          text: "Logout",
          handler: "logout"
        }
      ]
    }
  ],
  addMarker: function(marker) {
    var me = this;

    if (!marker.position) {
      marker.position = new google.maps.LatLng(marker.lat, marker.lng);
    }

    var m = new google.maps.Marker(marker);

    m.setMap(me.gmap);

    google.maps.event.addListener(m, "click", function() {
      me.fireEvent("markerClick", m);
    });

    return m;
  }
});
