Ext.define("Evoksi.view.evoksi.EvoksiController", {
    extend: "Ext.app.ViewController",
    alias: "controller.evoksi",
    requires: [
        "Ext.container.Container",
        "Ext.layout.container.Border",
        "Ext.layout.container.Fit",
        "Ext.ux.GMapPanel",
        "Ext.ux.IFrame",
        "Ext.window.Window"
    ],

    config: {
        listen: {
            component: {
                evoksi: {
                    markerClick: function(marker) {
                        var store = this.getView()
                            .getViewModel()
                            .getStore("myStore");
                        var first = true;
                        if (marker.performers) {
                            store.loadData(marker.performers);
                        }
                        var win = Ext.create("Ext.window.Window", {
                            title:
                                marker.title == "" ? "New event" : marker.title, // Marker title
                            height: 600,
                            width: "70%",
                            modal: true,
                            layout: "border",
                            maximizable: false,
                            resizable: false,
                            cls: "evoksi-window",
                            items: [
                                {
                                    xtype: "gmappanel",
                                    region: "west",
                                    split: true,
                                    splitterResize: false,
                                    width: 300,
                                    center: {
                                        lat: marker.lat, // Marker latitude
                                        lng: marker.lng // Marker longitude
                                    },
                                    markers: [
                                        {
                                            lat: marker.lat,
                                            lng: marker.lng,
                                            animation:
                                                google.maps.Animation.BOUNCE
                                        }
                                    ],
                                    mapOptions: {
                                        mapTypeId:
                                            google.maps.MapTypeId.ROADMAP,
                                        zoom: 15
                                    }
                                },
                                {
                                    xtype: "panel",
                                    cls: "evoksi-panel-body",
                                    region: "center",
                                    layout: "vbox",
                                    items: [
                                        {
                                            xtype: "textfield",
                                            fieldLabel: "Title",
                                            reference: "titleField",
                                            value: marker.title,
                                            width: "90%"
                                        },
                                        {
                                            xtype: "textarea",
                                            fieldLabel: "Description",
                                            reference: "descriptionArea",
                                            value: marker.description,
                                            width: "90%"
                                        },
                                        {
                                            xtype: "grid",
                                            reference: "myGrid",
                                            title: "Performers",
                                            height: 300,
                                            width: "90%",
                                            store: store,
                                            columns: [
                                                {
                                                    text: "Name",
                                                    dataIndex: "name"
                                                },
                                                {
                                                    text: "Date",
                                                    dataIndex: "date",
                                                    flex: 1
                                                },
                                                {
                                                    text: "Time",
                                                    dataIndex: "time",
                                                    flex: 1
                                                }
                                            ],
                                            listeners: {
                                                select: function(obj,item,index) {
                                                    var record = store.getAt(index);
                                                    var popup = Ext.create(
                                                        "Ext.panel.Panel",
                                                        {
                                                            floating: true,
                                                            centered: true,
                                                            cls: "evoksi-add-performer",
                                                            title: "Edit performer",
                                                            modal: true,
                                                            width: 300,
                                                            height: 400,
                                                            draggable: false,
                                                            maximizable: false,
                                                            items: [
                                                                {
                                                                    xtype: "textfield",
                                                                    fieldLabel: "Name",
                                                                    reference: "name",
                                                                    value: record.get("name")
                                                                },
                                                                {
                                                                    xtype: "textfield",
                                                                    fieldLabel: "Date",
                                                                    reference: "date",
                                                                    value: record.get("date")
                                                                },
                                                                {
                                                                    xtype: "textfield",
                                                                    fieldLabel: "Time",
                                                                    reference: "time",
                                                                    value: record.get("time")
                                                                }
                                                            ],
                                                            buttons: [
                                                                {
                                                                    text: "Save",
                                                                    formBind: true,
                                                                    listeners: {
                                                                        click: function() {
                                                                            record.beginEdit();
                                                                            record.set("name", popup.items.items[0].value);
                                                                            record.set("date", popup.items.items[1].value);
                                                                            record.set("time", popup.items.items[2].value);
                                                                            record.endEdit();
                                                                            popup.hide();
                                                                        }
                                                                    }
                                                                },
                                                                {
                                                                    text: "Cancel",
                                                                    handler: function() {
                                                                        popup.hide();
                                                                    }
                                                                },
                                                                {
                                                                    text: "Delete",
                                                                    handler: function() {
                                                                        function deleteStuff(btn) {
                                                                            if (btn == "yes") {
                                                                                store.removeAt(index);
                                                                                popup.hide();
                                                                            }
                                                                        }

                                                                        Ext.Msg.show(
                                                                            {
                                                                                title: "Delete performer",
                                                                                msg: "Are you sure?",
                                                                                buttons:Ext.Msg.YESNO,
                                                                                icon: Ext.Msg.WARNING,
                                                                                fn: deleteStuff
                                                                            }
                                                                        );
                                                                    }
                                                                }
                                                            ]
                                                        }
                                                    ).show();
                                                }
                                            }
                                        }
                                    ],
                                    buttons: [
                                        {
                                            text: "Add",
                                            handler: function() {
                                                var popup = Ext.create(
                                                    "Ext.panel.Panel",
                                                    {
                                                        floating: true,
                                                        centered: true,
                                                        cls: "evoksi-add-performer",
                                                        title: "Add performer",
                                                        modal: true,
                                                        width: 300,
                                                        height: 400,
                                                        draggable: false,
                                                        maximizable: false,
                                                        items: [
                                                            {
                                                                xtype: "textfield",
                                                                fieldLabel: "Name",
                                                                reference: "name"
                                                            },
                                                            {
                                                                xtype: "textfield",
                                                                fieldLabel: "Date",
                                                                reference: "date"
                                                            },
                                                            {
                                                                xtype: "textfield",
                                                                fieldLabel: "Time",
                                                                reference: "time"
                                                            }
                                                        ],
                                                        buttons: [
                                                            {
                                                                text: "Save",
                                                                formBind: true,
                                                                listeners: {
                                                                    click: function() {
                                                                        if (first) {
                                                                            store.each(function(item) {
                                                                                var dat = {
                                                                                    name: item.data.name,
                                                                                    date: item.data.date,
                                                                                    time: item.data.time
                                                                                };
                                                                                store.insert(0,dat);
                                                                            });
                                                                            first = false;
                                                                        }
                                                                        var newPerformer = {
                                                                            name: popup.items.items[0].value,
                                                                            date: popup.items.items[1].value,
                                                                            time: popup.items.items[2].value
                                                                        };
                                                                        store.insert(0, newPerformer);
                                                                        popup.hide();
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                text: "Cancel",
                                                                handler: function() {
                                                                    popup.hide();
                                                                }
                                                            }
                                                        ]
                                                    }
                                                ).show();
                                            }
                                        },
                                        {
                                            text: "Update",
                                            handler: function() {
                                                var perf = [];

                                                store.each(function(rec) {
                                                    perf.push(rec.data);
                                                });

                                                var newMarker = {
                                                    title: win.items.items[2].items.items[0].value,
                                                    description: win.items.items[2].items.items[1].value,
                                                    performers: perf,
                                                    lat: marker.lat,
                                                    lng: marker.lng,
                                                    animation: google.maps.Animation.DROP
                                                };

                                                if (marker.saved != undefined && marker.saved == false) {
                                                    newMarker.access = dbref.ref().child("data").push().key;
                                                } else {
                                                    newMarker.access = marker.access;
                                                }

                                                var updates = {};

                                                updates["/data/" + newMarker.access] = newMarker;

                                                dbref.ref().update(updates);

                                                win.hide();
                                            }
                                        },
                                        {
                                            text: "Delete",
                                            handler: function() {
                                                function deleteStuff(btn) {
                                                    if (btn == "yes") {
                                                        var i = markers.length;
                                                        var newMarkers = [];
                                                        while (i) {
                                                            i--;
                                                            if (markers[i].access == marker.access) {
                                                                markers[i].setMap(null);
                                                            } else {
                                                                newMarkers.push(markers[i]);
                                                            }
                                                        }

                                                        markers = newMarkers;

                                                        dbref.ref("/data/" + marker.access).remove();
                                                        win.close();
                                                    }
                                                }

                                                Ext.Msg.show({
                                                    title: "Delete event",
                                                    msg: "Are you sure?",
                                                    fn: deleteStuff,
                                                    buttons: Ext.Msg.YESNO,
                                                    icon: Ext.Msg.WARNING
                                                });
                                            }
                                        }
                                    ]
                                }
                            ]
                        }).show();
                    },
                    click: function(evt) {
                        var me = this,
                            map = me.getView(),
                            key = dbref.ref().child("data").push().key,
                            marker = {
                                access: key,
                                lat: evt.latLng.lat(),
                                lng: evt.latLng.lng(),
                                title: "",
                                description: "",
                                performers: [],
                                animation: google.maps.Animation.DROP,
                                saved: false
                            };

                        markers.push(map.addMarker(marker));
                    },
                    mapready: function() {
                        var me = this;
                        var map = me.getView();
                        google.maps.event.addListener(
                            map.gmap,
                            "click",
                            function(e) {
                                map.fireEvent("click", e);
                            }
                        );
                    }
                }
            }
        }
    },

    showLogin: function() {
        var me = this,
            map = me.getView();
        var loginWindow = Ext.create("Ext.panel.Panel", {
            floating: true,
            centered: true,
            cls: "evoksi-view-login",
            title: "Login",
            modal: true,
            width: 300,
            height: 400,
            draggable: false,
            maximizable: false,
            items: [
                {
                    xtype: "textfield",
                    fieldLabel: "Username"
                },
                {
                    xtype: "textfield",
                    inputType: "password",
                    fieldLabel: "Password"
                }
            ],
            buttons: [
                {
                    text: "Login",
                    formBind: true,
                    handler: function() {
                        var username = loginWindow.items.items[0].value;
                        var password = loginWindow.items.items[1].value;

                        if (username == "admin" && password == "cpAdmin01") {
                            Ext.Ajax.request({
                                url: dataURL,
                                scope: this,
                                success: function(data) {
                                    var info = Ext.decode(data.responseText);

                                    if (info != null) {
                                        Ext.Object.each(info, function(
                                            obj,
                                            index
                                        ) {
                                            markers.push(map.addMarker(index));
                                        });
                                    }
                                }
                            });
                            loginWindow.hide();
                        } else {
                            Ext.Msg.show({
                                title: "Login failed",
                                msg: "Invalid username or password",
                                buttons: Ext.Msg.OK,
                                icon: Ext.Msg.ERROR
                            });
                        }
                    }
                }
            ]
        }).show();
    },

    logout: function() {
        var i = markers.length;
        while (i) {
            i--;
            markers[i].setMap(null);
        }

        markers = [];

        this.showLogin();
    },
    init: function() {
        var me = this,
            map = me.getView();

        this.showLogin();
    }
});
