package app.model;

import java.util.Collection;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.persistence.JoinColumn;

@Entity
@Table(name =  "Korisnici", uniqueConstraints = @UniqueConstraint(columnNames = "email"))
public class Korisnik {
	
	@Id
	@GeneratedValue(strategy =  GenerationType.IDENTITY)
	private Long id;
	
	@Column(name = "Ime")
	private String ime;
	
	@Column(name = "Prezime")
	private String prezime;
	
	private String email;
	
	private String lozinka;
	
	@ManyToMany(fetch = FetchType.EAGER, cascade = CascadeType.ALL)
	@JoinTable(
			name = "Korisnicke_Uloge",
			joinColumns = @JoinColumn(
		            name = "Korisnik_id", referencedColumnName = "id"),
			inverseJoinColumns = @JoinColumn(
				            name = "Uloga_id", referencedColumnName = "id"))
	
	private Collection<Uloga> uloge;
	
	public Korisnik() {
		
	}
	
	public Korisnik(String ime, String prezime, String email, String lozinka, Collection<Uloga> uloge) {
		super();
		this.ime = ime;
		this.prezime = prezime;
		this.email = email;
		this.lozinka = lozinka;
		this.uloge = uloge;
	}
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public String getIme() {
		return ime;
	}
	public void setIme(String ime) {
		this.ime= ime;
	}
	public String getPrezime() {
		return prezime;
	}
	public void setPrezime(String Prezime) {
		this.prezime = prezime;
	}
	public String getEmail() {
		return email;
	}
	public void setEmail(String email) {
		this.email = email;
	}
	public String getLozinka() {
		return lozinka;
	}
	public void setLozinka(String lozinka) {
		this.lozinka = lozinka;
	}
	public Collection<Uloga> getUloge() {
		return uloge;
	}
	public void setUloge(Collection<Uloga> uloge) {
		this.uloge= uloge;
	}

}
