package app.usluga.web;

import java.util.List;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

import app.model.Korisnik;
import app.model.Oglas;
import app.usluga.DodajUsluga;
import app.usluga.KorisnickaUsluga;

@Controller
@RequestMapping("/adminKorisnik")
public class ListaKorisnikKontroler {

	private KorisnickaUsluga ku;

	public ListaKorisnikKontroler(KorisnickaUsluga ku) {
		super();
		this.ku = ku;
	}
	
	@GetMapping
	public String izlistajKorisnike(Model model)
	{
		List<Korisnik> korisnici = ku.izlistaj();
		model.addAttribute("korisnici",korisnici);
		return "listaKorisnik";
	}
	
	@GetMapping("/obrisiKorisnika/{id}")
	public String obrisiKorisnika(@PathVariable(value="id") int id) {
		this.ku.izbrisiKorisnika(id);
		return "redirect:/adminKorisnik";
	}
}
