package app.usluga.web;

import java.util.List;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

import app.model.Korisnik;
import app.model.Oglas;
import app.usluga.DodajUsluga;
import app.usluga.KorisnickaUsluga;
import app.usluga.OglasUsluga;

@Controller
@RequestMapping("/adminOglas")
public class ListaOglasKontroler {

	private OglasUsluga ou;

	public ListaOglasKontroler(OglasUsluga ou) {
		super();
		this.ou = ou;
	}
	
	@GetMapping
	public String izlistajOglase(Model model)
	{
		List<Oglas> oglasi = ou.getAll();
		model.addAttribute("oglasi",oglasi);
		return "listaOglas";
	}
	
	@GetMapping("/obrisiOglas/{id}")
	public String obrisiOglas(@PathVariable(value="id") int id) {
		this.ou.izbrisiOglas(id);
		return "redirect:/adminOglas";
	}
}
