package app.usluga.web;

import app.model.Oglas;
import app.usluga.DodajUsluga;
import app.usluga.KorisnickaUsluga;
import app.usluga.OglasUsluga;
import app.usluga.web.transfer.Registracija;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

@Controller
@RequestMapping("/dodaj")
public class DodajKontrol {

	private DodajUsluga ku;

	public DodajKontrol(DodajUsluga ku) {
		super();
		this.ku = ku;
	}
	
	@ModelAttribute("user")
    public Oglas registracija() {
        return new Oglas();
    }



	@GetMapping
	public String prikaziRegFormu() {

		return "dodaj";
	}
	
	@PostMapping
	public String registruj(@ModelAttribute("user") Oglas o) {
		System.out.println();
		o.setVlasnik_id(SecurityContextHolder.getContext().getAuthentication().getPrincipal().hashCode());
		ku.save(o);
		return "redirect:/";
	}
}
