package app.usluga.web;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

import app.usluga.KorisnickaUsluga;
import app.usluga.web.transfer.Registracija;

@Controller
@RequestMapping("/registration")
public class RegKontroler {

	private KorisnickaUsluga ku;

	public RegKontroler(KorisnickaUsluga ku) {
		super();
		this.ku = ku;
	}
	
	@ModelAttribute("user")
    public Registracija registracija() {
        return new Registracija();
    }
	
	@GetMapping
	public String prikaziRegFormu() {
		return "registration";
	}
	
	@PostMapping
	public String registruj(@ModelAttribute("user") Registracija r) {
		ku.save(r);
		return "redirect:/registration?success";
	}
}
